/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MatMul", inputsClass=Inputs.class)
public final class MatMul<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "MatMul";
    private Output<T> product;

    public MatMul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static <T extends TType> MatMul<T> create(Scope scope, Operand<T> a, Operand<T> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.gradA != null) {
                    opBuilder.setAttr("grad_a", opts.gradA);
                }
                if (opts.gradB == null) continue;
                opBuilder.setAttr("grad_b", opts.gradB);
            }
        }
        return new MatMul<T>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options gradA(Boolean gradA) {
        return new Options().gradA(gradA);
    }

    public static Options gradB(Boolean gradB) {
        return new Options().gradB(gradB);
    }

    public Output<T> product() {
        return this.product;
    }

    @Override
    public Output<T> asOutput() {
        return this.product;
    }

    @OpInputsMetadata(outputsClass=MatMul.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<MatMul<T>> {
        public final Operand<T> a;
        public final Operand<T> b;
        public final boolean transposeA;
        public final boolean transposeB;
        public final DataType T;
        public final boolean gradA;
        public final boolean gradB;

        public Inputs(GraphOperation op) {
            super(new MatMul(op), op, Arrays.asList("transpose_a", "transpose_b", "T", "grad_a", "grad_b"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.transposeA = op.attributes().getAttrBool("transpose_a");
            this.transposeB = op.attributes().getAttrBool("transpose_b");
            this.T = op.attributes().getAttrType("T");
            this.gradA = op.attributes().getAttrBool("grad_a");
            this.gradB = op.attributes().getAttrBool("grad_b");
        }
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean gradA;
        private Boolean gradB;

        private Options() {
        }

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options gradA(Boolean gradA) {
            this.gradA = gradA;
            return this;
        }

        public Options gradB(Boolean gradB) {
            this.gradB = gradB;
            return this;
        }
    }
}

