/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="BatchMatrixInverse", inputsClass=Inputs.class)
public final class BatchMatrixInverse<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "BatchMatrixInverse";
    private Output<T> output;

    public BatchMatrixInverse(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> BatchMatrixInverse<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new BatchMatrixInverse<T>(opBuilder.build());
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=BatchMatrixInverse.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<BatchMatrixInverse<T>> {
        public final Operand<T> input;
        public final boolean adjoint;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new BatchMatrixInverse(op), op, Arrays.asList("adjoint", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.adjoint = op.attributes().getAttrBool("adjoint");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean adjoint;

        private Options() {
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }
    }
}

