/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="CropAndResizeGradBoxes", inputsClass=Inputs.class)
public final class CropAndResizeGradBoxes
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "CropAndResizeGradBoxes";
    private Output<TFloat32> output;

    public CropAndResizeGradBoxes(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static CropAndResizeGradBoxes create(Scope scope, Operand<TFloat32> grads, Operand<? extends TNumber> image, Operand<TFloat32> boxes, Operand<TInt32> boxInd, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(image.asOutput());
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(boxInd.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.method == null) continue;
                opBuilder.setAttr("method", opts.method);
            }
        }
        return new CropAndResizeGradBoxes(opBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public Output<TFloat32> output() {
        return this.output;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=CropAndResizeGradBoxes.class)
    public static class Inputs
    extends RawOpInputs<CropAndResizeGradBoxes> {
        public final Operand<TFloat32> grads;
        public final Operand<? extends TNumber> image;
        public final Operand<TFloat32> boxes;
        public final Operand<TInt32> boxInd;
        public final DataType T;
        public final String method;

        public Inputs(GraphOperation op) {
            super(new CropAndResizeGradBoxes(op), op, Arrays.asList("T", "method"));
            int inputIndex = 0;
            this.grads = op.input(inputIndex++);
            this.image = op.input(inputIndex++);
            this.boxes = op.input(inputIndex++);
            this.boxInd = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.method = op.attributes().getAttrString("method");
        }
    }

    public static class Options {
        private String method;

        private Options() {
        }

        public Options method(String method) {
            this.method = method;
            return this;
        }
    }
}

