/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SnapshotChunkDataset", inputsClass=Inputs.class)
public final class SnapshotChunkDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SnapshotChunkDataset";
    private Output<? extends TType> handle;

    public SnapshotChunkDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static SnapshotChunkDataset create(Scope scope, Operand<TString> chunkFile, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(chunkFile.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression == null) continue;
                opBuilder.setAttr("compression", opts.compression);
            }
        }
        return new SnapshotChunkDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=SnapshotChunkDataset.class)
    public static class Inputs
    extends RawOpInputs<SnapshotChunkDataset> {
        public final Operand<TString> chunkFile;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String compression;

        public Inputs(GraphOperation op) {
            super(new SnapshotChunkDataset(op), op, Arrays.asList("output_types", "output_shapes", "compression"));
            int inputIndex = 0;
            this.chunkFile = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.compression = op.attributes().getAttrString("compression");
        }
    }

    public static class Options {
        private String compression;

        private Options() {
        }

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }
    }
}

