/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Unbatch", inputsClass=Inputs.class)
public final class Unbatch<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Unbatch";
    private Output<T> unbatchedTensor;

    public Unbatch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.unbatchedTensor = operation.output(outputIdx++);
    }

    public static <T extends TType> Unbatch<T> create(Scope scope, Operand<T> batchedTensor, Operand<TInt64> batchIndex, Operand<TInt64> id, Long timeoutMicros, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(batchedTensor.asOutput());
        opBuilder.addInput(batchIndex.asOutput());
        opBuilder.addInput(id.asOutput());
        opBuilder.setAttr("timeout_micros", timeoutMicros);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new Unbatch<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<T> unbatchedTensor() {
        return this.unbatchedTensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.unbatchedTensor;
    }

    @OpInputsMetadata(outputsClass=Unbatch.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Unbatch<T>> {
        public final Operand<T> batchedTensor;
        public final Operand<TInt64> batchIndex;
        public final Operand<TInt64> id;
        public final long timeoutMicros;
        public final String container;
        public final String sharedName;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Unbatch(op), op, Arrays.asList("timeout_micros", "container", "shared_name", "T"));
            int inputIndex = 0;
            this.batchedTensor = op.input(inputIndex++);
            this.batchIndex = op.input(inputIndex++);
            this.id = op.input(inputIndex++);
            this.timeoutMicros = op.attributes().getAttrInt("timeout_micros");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

