/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="EmptyTensorList", inputsClass=Inputs.class)
public final class EmptyTensorList
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "EmptyTensorList";
    private Output<? extends TType> handle;

    public EmptyTensorList(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static <U extends TType> EmptyTensorList create(Scope scope, Operand<? extends TNumber> elementShape, Operand<TInt32> maxNumElements, Class<U> elementDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.addInput(maxNumElements.asOutput());
        opBuilder.setAttr("element_dtype", Operands.toDataType(elementDtype));
        return new EmptyTensorList(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=EmptyTensorList.class)
    public static class Inputs
    extends RawOpInputs<EmptyTensorList> {
        public final Operand<? extends TNumber> elementShape;
        public final Operand<TInt32> maxNumElements;
        public final DataType elementDtype;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new EmptyTensorList(op), op, Arrays.asList("element_dtype", "shape_type"));
            int inputIndex = 0;
            this.elementShape = op.input(inputIndex++);
            this.maxNumElements = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

