/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="StringSplitV2", inputsClass=Inputs.class)
public final class StringSplit
extends RawOp {
    public static final String OP_NAME = "StringSplitV2";
    private Output<TInt64> indices;
    private Output<TString> values;
    private Output<TInt64> shape;

    public StringSplit(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.shape = operation.output(outputIdx++);
    }

    public static StringSplit create(Scope scope, Operand<TString> input, Operand<TString> sep, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "StringSplit");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(sep.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxsplit == null) continue;
                opBuilder.setAttr("maxsplit", opts.maxsplit);
            }
        }
        return new StringSplit(opBuilder.build());
    }

    public static Options maxsplit(Long maxsplit) {
        return new Options().maxsplit(maxsplit);
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<TString> values() {
        return this.values;
    }

    public Output<TInt64> shape() {
        return this.shape;
    }

    @OpInputsMetadata(outputsClass=StringSplit.class)
    public static class Inputs
    extends RawOpInputs<StringSplit> {
        public final Operand<TString> input;
        public final Operand<TString> sep;
        public final long maxsplit;

        public Inputs(GraphOperation op) {
            super(new StringSplit(op), op, Arrays.asList("maxsplit"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.sep = op.input(inputIndex++);
            this.maxsplit = op.attributes().getAttrInt("maxsplit");
        }
    }

    public static class Options {
        private Long maxsplit;

        private Options() {
        }

        public Options maxsplit(Long maxsplit) {
            this.maxsplit = maxsplit;
            return this;
        }
    }
}

