/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="BatchMatrixSolveLs", inputsClass=Inputs.class)
public final class BatchMatrixSolveLs<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "BatchMatrixSolveLs";
    private Output<T> output;

    public BatchMatrixSolveLs(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> BatchMatrixSolveLs<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Operand<TFloat64> l2Regularizer, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(l2Regularizer.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.fast == null) continue;
                opBuilder.setAttr("fast", opts.fast);
            }
        }
        return new BatchMatrixSolveLs<T>(opBuilder.build());
    }

    public static Options fast(Boolean fast) {
        return new Options().fast(fast);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=BatchMatrixSolveLs.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<BatchMatrixSolveLs<T>> {
        public final Operand<T> matrix;
        public final Operand<T> rhs;
        public final Operand<TFloat64> l2Regularizer;
        public final DataType T;
        public final boolean fast;

        public Inputs(GraphOperation op) {
            super(new BatchMatrixSolveLs(op), op, Arrays.asList("T", "fast"));
            int inputIndex = 0;
            this.matrix = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.l2Regularizer = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.fast = op.attributes().getAttrBool("fast");
        }
    }

    public static class Options {
        private Boolean fast;

        private Options() {
        }

        public Options fast(Boolean fast) {
            this.fast = fast;
            return this;
        }
    }
}

