/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="For", inputsClass=Inputs.class)
public final class For
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "For";
    private List<Output<?>> output;

    public For(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static For create(Scope scope, Operand<TInt32> start, Operand<TInt32> limit, Operand<TInt32> delta, Iterable<Operand<?>> input, ConcreteFunction body) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(start.asOutput());
        opBuilder.addInput(limit.asOutput());
        opBuilder.addInput(delta.asOutput());
        opBuilder.addInputList(Operands.asOutputs(input));
        opBuilder.setAttr("body", body);
        return new For(opBuilder.build());
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=For.class)
    public static class Inputs
    extends RawOpInputs<For> {
        public final Operand<TInt32> start;
        public final Operand<TInt32> limit;
        public final Operand<TInt32> delta;
        public final Iterable<Operand<?>> input;
        public final DataType[] T;

        public Inputs(GraphOperation op) {
            super(new For(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.start = op.input(inputIndex++);
            this.limit = op.input(inputIndex++);
            this.delta = op.input(inputIndex++);
            int inputLength = op.inputListLength("input");
            this.input = Arrays.asList((Operand[])op.inputList(inputIndex, inputLength));
            inputIndex += inputLength;
            this.T = op.attributes().getAttrTypeList("T");
        }
    }
}

