/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MergeDedupData", inputsClass=Inputs.class)
public final class MergeDedupData
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "MergeDedupData";
    private Output<? extends TType> output;

    public MergeDedupData(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static MergeDedupData create(Scope scope, Operand<? extends TNumber> integerTensor, Operand<? extends TNumber> floatTensor, String tupleMask, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(integerTensor.asOutput());
        opBuilder.addInput(floatTensor.asOutput());
        opBuilder.setAttr("tuple_mask", tupleMask);
        if (options != null) {
            for (Options opts : options) {
                if (opts.config == null) continue;
                opBuilder.setAttr("config", opts.config);
            }
        }
        return new MergeDedupData(opBuilder.build());
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public Output<? extends TType> output() {
        return this.output;
    }

    @Override
    public Output<TType> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=MergeDedupData.class)
    public static class Inputs
    extends RawOpInputs<MergeDedupData> {
        public final Operand<? extends TNumber> integerTensor;
        public final Operand<? extends TNumber> floatTensor;
        public final String tupleMask;
        public final DataType integerType;
        public final DataType floatType;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new MergeDedupData(op), op, Arrays.asList("tuple_mask", "integer_type", "float_type", "config"));
            int inputIndex = 0;
            this.integerTensor = op.input(inputIndex++);
            this.floatTensor = op.input(inputIndex++);
            this.tupleMask = op.attributes().getAttrString("tuple_mask");
            this.integerType = op.attributes().getAttrType("integer_type");
            this.floatType = op.attributes().getAttrType("float_type");
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private String config;

        private Options() {
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }
    }
}

