/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;

@OpMetadata(opType="StringFormat", inputsClass=Inputs.class)
public final class StringFormat
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "StringFormat";
    private Output<TString> output;

    public StringFormat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static StringFormat create(Scope scope, Iterable<Operand<?>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        if (options != null) {
            for (Options opts : options) {
                if (opts.template != null) {
                    opBuilder.setAttr("template", opts.template);
                }
                if (opts.placeholder != null) {
                    opBuilder.setAttr("placeholder", opts.placeholder);
                }
                if (opts.summarize == null) continue;
                opBuilder.setAttr("summarize", opts.summarize);
            }
        }
        return new StringFormat(opBuilder.build());
    }

    public static Options template(String template) {
        return new Options().template(template);
    }

    public static Options placeholder(String placeholder) {
        return new Options().placeholder(placeholder);
    }

    public static Options summarize(Long summarize) {
        return new Options().summarize(summarize);
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=StringFormat.class)
    public static class Inputs
    extends RawOpInputs<StringFormat> {
        public final Iterable<Operand<?>> inputs;
        public final DataType[] T;
        public final String template;
        public final String placeholder;
        public final long summarize;

        public Inputs(GraphOperation op) {
            super(new StringFormat(op), op, Arrays.asList("T", "template", "placeholder", "summarize"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.T = op.attributes().getAttrTypeList("T");
            this.template = op.attributes().getAttrString("template");
            this.placeholder = op.attributes().getAttrString("placeholder");
            this.summarize = op.attributes().getAttrInt("summarize");
        }
    }

    public static class Options {
        private String template;
        private String placeholder;
        private Long summarize;

        private Options() {
        }

        public Options template(String template) {
            this.template = template;
            return this;
        }

        public Options placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Options summarize(Long summarize) {
            this.summarize = summarize;
            return this;
        }
    }
}

