/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseDenseMatmulWithCsrInput", inputsClass=Inputs.class)
public final class XlaSparseDenseMatmulWithCsrInput
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "XlaSparseDenseMatmulWithCsrInput";
    private Output<TFloat32> activations;

    public XlaSparseDenseMatmulWithCsrInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
    }

    public static XlaSparseDenseMatmulWithCsrInput create(Scope scope, Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> embeddingTable, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Long inputSize, Float quantizationConfigLow, Float quantizationConfigHigh, Long quantizationConfigNumBuckets, String tableName) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(rowPointers.asOutput());
        opBuilder.addInput(sortedSampleIds.asOutput());
        opBuilder.addInput(sortedTokenIds.asOutput());
        opBuilder.addInput(sortedGains.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(numMinibatchesPerPhysicalSparseCore.asOutput());
        opBuilder.setAttr("input_size", inputSize);
        opBuilder.setAttr("quantization_config_low", quantizationConfigLow.floatValue());
        opBuilder.setAttr("quantization_config_high", quantizationConfigHigh.floatValue());
        opBuilder.setAttr("quantization_config_num_buckets", quantizationConfigNumBuckets);
        opBuilder.setAttr("table_name", tableName);
        return new XlaSparseDenseMatmulWithCsrInput(opBuilder.build());
    }

    public Output<TFloat32> activations() {
        return this.activations;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.activations;
    }

    @OpInputsMetadata(outputsClass=XlaSparseDenseMatmulWithCsrInput.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseDenseMatmulWithCsrInput> {
        public final Operand<TInt32> rowPointers;
        public final Operand<TInt32> sortedSampleIds;
        public final Operand<TInt32> sortedTokenIds;
        public final Operand<TFloat32> sortedGains;
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TInt32> numMinibatchesPerPhysicalSparseCore;
        public final long inputSize;
        public final float quantizationConfigLow;
        public final float quantizationConfigHigh;
        public final long quantizationConfigNumBuckets;
        public final String tableName;

        public Inputs(GraphOperation op) {
            super(new XlaSparseDenseMatmulWithCsrInput(op), op, Arrays.asList("input_size", "quantization_config_low", "quantization_config_high", "quantization_config_num_buckets", "table_name"));
            int inputIndex = 0;
            this.rowPointers = op.input(inputIndex++);
            this.sortedSampleIds = op.input(inputIndex++);
            this.sortedTokenIds = op.input(inputIndex++);
            this.sortedGains = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.numMinibatchesPerPhysicalSparseCore = op.input(inputIndex++);
            this.inputSize = op.attributes().getAttrInt("input_size");
            this.quantizationConfigLow = op.attributes().getAttrFloat("quantization_config_low");
            this.quantizationConfigHigh = op.attributes().getAttrFloat("quantization_config_high");
            this.quantizationConfigNumBuckets = op.attributes().getAttrInt("quantization_config_num_buckets");
            this.tableName = op.attributes().getAttrString("table_name");
        }
    }
}

