/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="FakeQuantWithMinMaxVars", inputsClass=Inputs.class)
public final class FakeQuantWithMinMaxVars
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "FakeQuantWithMinMaxVars";
    private Output<TFloat32> outputs;

    public FakeQuantWithMinMaxVars(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputs = operation.output(outputIdx++);
    }

    public static FakeQuantWithMinMaxVars create(Scope scope, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVars(opBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<TFloat32> outputs() {
        return this.outputs;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputs;
    }

    @OpInputsMetadata(outputsClass=FakeQuantWithMinMaxVars.class)
    public static class Inputs
    extends RawOpInputs<FakeQuantWithMinMaxVars> {
        public final Operand<TFloat32> inputs;
        public final Operand<TFloat32> min;
        public final Operand<TFloat32> max;
        public final long numBits;
        public final boolean narrowRange;

        public Inputs(GraphOperation op) {
            super(new FakeQuantWithMinMaxVars(op), op, Arrays.asList("num_bits", "narrow_range"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.min = op.input(inputIndex++);
            this.max = op.input(inputIndex++);
            this.numBits = op.attributes().getAttrInt("num_bits");
            this.narrowRange = op.attributes().getAttrBool("narrow_range");
        }
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        private Options() {
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }
    }
}

