/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="NthElement", inputsClass=Inputs.class)
public final class NthElement<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "NthElement";
    private Output<T> values;

    public NthElement(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
    }

    public static <T extends TNumber> NthElement<T> create(Scope scope, Operand<T> input, Operand<TInt32> n, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(n.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.reverse == null) continue;
                opBuilder.setAttr("reverse", opts.reverse);
            }
        }
        return new NthElement<T>(opBuilder.build());
    }

    public static Options reverse(Boolean reverse) {
        return new Options().reverse(reverse);
    }

    public Output<T> values() {
        return this.values;
    }

    @Override
    public Output<T> asOutput() {
        return this.values;
    }

    @OpInputsMetadata(outputsClass=NthElement.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<NthElement<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> n;
        public final boolean reverse;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new NthElement(op), op, Arrays.asList("reverse", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.n = op.input(inputIndex++);
            this.reverse = op.attributes().getAttrBool("reverse");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean reverse;

        private Options() {
        }

        public Options reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }
    }
}

