/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="LeakyRelu", inputsClass=Inputs.class)
public final class LeakyRelu<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "LeakyRelu";
    private Output<T> activations;

    public LeakyRelu(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
    }

    public static <T extends TNumber> LeakyRelu<T> create(Scope scope, Operand<T> features, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(features.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alpha == null) continue;
                opBuilder.setAttr("alpha", opts.alpha.floatValue());
            }
        }
        return new LeakyRelu<T>(opBuilder.build());
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public Output<T> activations() {
        return this.activations;
    }

    @Override
    public Output<T> asOutput() {
        return this.activations;
    }

    @OpInputsMetadata(outputsClass=LeakyRelu.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<LeakyRelu<T>> {
        public final Operand<T> features;
        public final float alpha;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new LeakyRelu(op), op, Arrays.asList("alpha", "T"));
            int inputIndex = 0;
            this.features = op.input(inputIndex++);
            this.alpha = op.attributes().getAttrFloat("alpha");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Float alpha;

        private Options() {
        }

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }
    }
}

