/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="VariableV2", inputsClass=Inputs.class)
public final class Variable<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "VariableV2";
    private Output<T> ref;

    public Variable(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.ref = operation.output(outputIdx++);
    }

    public static <T extends TType> Variable<T> create(Scope scope, Shape shape, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Variable");
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new Variable<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<T> ref() {
        return this.ref;
    }

    @Override
    public Output<T> asOutput() {
        return this.ref;
    }

    @OpInputsMetadata(outputsClass=Variable.class)
    public static class Inputs
    extends RawOpInputs<Variable<?>> {
        public final Shape shape;
        public final DataType dtype;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new Variable(op), op, Arrays.asList("shape", "dtype", "container", "shared_name"));
            boolean inputIndex = false;
            this.shape = op.attributes().getAttrShape("shape");
            this.dtype = op.attributes().getAttrType("dtype");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

