/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Graph;

final class NameScope {
    private static final Pattern NAME_PATTERN = Pattern.compile("(.+)_(\\d+)", 32);
    private final String opPrefix;
    private final String opName;
    private final Map<String, Integer> ids;
    private static final Pattern NAME_REGEX = Pattern.compile("[A-Za-z0-9.][A-Za-z0-9_.\\-]*");

    NameScope withSubScope(String scopeName, ExecutionEnvironment env) {
        NameScope.checkPattern(NAME_REGEX, scopeName);
        String actualName = this.opName != null ? this.opName : scopeName;
        String newPrefix = this.fullyQualify(this.makeUnique(actualName));
        return new NameScope(newPrefix, null, null).withUsedFrom(env);
    }

    NameScope withName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        return new NameScope(this.opPrefix, name, this.ids);
    }

    void importIdsFrom(ExecutionEnvironment env) {
        if (env instanceof Graph) {
            ((Graph)env).operations().forEachRemaining(op -> {
                if (op.name().startsWith(this.opPrefix != null ? this.opPrefix : "")) {
                    String name = op.name();
                    if (this.opPrefix != null) {
                        name = name.substring(this.opPrefix.length() + 1);
                    }
                    if (!name.contains("/")) {
                        Matcher matcher = NAME_PATTERN.matcher(name);
                        if (matcher.find()) {
                            String realName = matcher.group(1);
                            int num = Integer.parseInt(matcher.group(2)) + 1;
                            if (!this.ids.containsKey(realName) || this.ids.get(realName) <= num) {
                                this.ids.put(realName, num);
                            }
                        } else if (!this.ids.containsKey(name)) {
                            this.ids.put(name, 1);
                        } else {
                            this.ids.put(name, this.ids.get(name) + 1);
                        }
                    }
                }
            });
        }
    }

    private NameScope withUsedFrom(ExecutionEnvironment env) {
        this.importIdsFrom(env);
        return this;
    }

    String makeOpName(String name) {
        NameScope.checkPattern(NAME_REGEX, name);
        String actualName = this.opName != null ? this.opName : name;
        return this.fullyQualify(this.makeUnique(actualName));
    }

    NameScope(ExecutionEnvironment env) {
        this(null, null, null);
        this.withUsedFrom(env);
    }

    private NameScope(String opPrefix, String opName, Map<String, Integer> ids) {
        this.opPrefix = opPrefix;
        this.opName = opName;
        this.ids = ids != null ? ids : new HashMap<String, Integer>();
    }

    String makeUnique(String id) {
        if (!this.ids.containsKey(id)) {
            this.ids.put(id, 1);
            return id;
        }
        int cur = this.ids.get(id);
        this.ids.put(id, cur + 1);
        return String.format("%s_%d", id, cur);
    }

    private String fullyQualify(String name) {
        if (this.opPrefix != null) {
            return String.format("%s/%s", this.opPrefix, name);
        }
        return name;
    }

    static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        return NAME_REGEX.matcher(name).matches();
    }

    private static void checkPattern(Pattern pattern, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Names cannot be null");
        }
        if (!pattern.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("invalid name: '%s' does not match the regular expression %s", name, NAME_REGEX.pattern()));
        }
    }
}

