/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sparse.slice;

import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicInteger;
import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.NdArrays;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffers;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.ndarray.impl.sparse.AbstractSparseNdArray;
import org.tensorflow.ndarray.impl.sparse.slice.SparseSlice;
import org.tensorflow.ndarray.index.Index;

public class BooleanSparseSlice
extends SparseSlice<Boolean, BooleanNdArray>
implements BooleanNdArray {
    public BooleanSparseSlice(AbstractSparseNdArray<Boolean, BooleanNdArray> source, long sourcePosition, DimensionalSpace dimensions) {
        super(source, sourcePosition, dimensions);
    }

    @Override
    public BooleanNdArray toDense() {
        BooleanDataBuffer dataBuffer = DataBuffers.ofBooleans(this.shape().size());
        this.copyTo(dataBuffer);
        return NdArrays.wrap(this.shape(), dataBuffer);
    }

    @Override
    public boolean getBoolean(long ... coordinates) {
        return (Boolean)this.getObject(coordinates);
    }

    @Override
    public BooleanNdArray setBoolean(boolean value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray setObject(Boolean value, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray set(NdArray<Boolean> src, long ... coordinates) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray copyTo(DataBuffer<Boolean> dst) {
        Boolean[] defaults = new Boolean[(int)this.shape().size()];
        dst.write((Boolean[])defaults);
        AtomicInteger i = new AtomicInteger();
        this.getIndices().elements(0).forEachIndexed((idx, l) -> {
            long[] coordinates = this.getIndicesCoordinates((LongNdArray)l);
            boolean value = ((BooleanNdArray)this.getValues()).getBoolean(i.getAndIncrement());
            dst.setObject(value, this.dimensions.positionOf(coordinates));
        });
        return this;
    }

    @Override
    public BooleanNdArray copyTo(BooleanDataBuffer dst) {
        return this.copyTo((DataBuffer)dst);
    }

    @Override
    public BooleanNdArray copyFrom(DataBuffer<Boolean> src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray copyFrom(BooleanDataBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public BooleanNdArray slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    @Override
    public BooleanNdArray slice(long position, DimensionalSpace sliceDimensions) {
        return new BooleanSparseSlice(this.source, position + this.sourcePosition, sliceDimensions);
    }

    @Override
    public BooleanNdArray get(long ... coordinates) {
        return (BooleanNdArray)super.get(coordinates);
    }

    @Override
    public BooleanNdArray copyTo(NdArray<Boolean> dst) {
        return (BooleanNdArray)super.copyTo(dst);
    }

    @Override
    public BooleanNdArray createDefaultArray() {
        return (BooleanNdArray)this.source.getDefaultArray();
    }
}

