/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="GetMinibatchSplitsWithPhysicalReplica", inputsClass=Inputs.class)
public final class GetMinibatchSplitsWithPhysicalReplica
extends RawOp {
    public static final String OP_NAME = "GetMinibatchSplitsWithPhysicalReplica";
    private Output<TInt32> sortedRowIds;
    private Output<TInt32> sortedColIds;
    private Output<TFloat32> sortedGains;
    private Output<TInt64> splits;
    private Output<TInt32> idCounts;
    private Output<TInt32> maxIds;
    private Output<TInt32> maxUniques;

    public GetMinibatchSplitsWithPhysicalReplica(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sortedRowIds = operation.output(outputIdx++);
        this.sortedColIds = operation.output(outputIdx++);
        this.sortedGains = operation.output(outputIdx++);
        this.splits = operation.output(outputIdx++);
        this.idCounts = operation.output(outputIdx++);
        this.maxIds = operation.output(outputIdx++);
        this.maxUniques = operation.output(outputIdx++);
    }

    public static GetMinibatchSplitsWithPhysicalReplica create(Scope scope, Operand<TString> programKey, Operand<TInt32> rowIds, Operand<TInt32> colIds, Operand<TFloat32> gains, Long sampleCount, Long numReplica, Long tableVocabSize, Long featureWidth, Long numScPerChip, String tableName, String miniBatchSplits) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(programKey.asOutput());
        opBuilder.addInput(rowIds.asOutput());
        opBuilder.addInput(colIds.asOutput());
        opBuilder.addInput(gains.asOutput());
        opBuilder.setAttr("sample_count", sampleCount);
        opBuilder.setAttr("num_replica", numReplica);
        opBuilder.setAttr("table_vocab_size", tableVocabSize);
        opBuilder.setAttr("feature_width", featureWidth);
        opBuilder.setAttr("num_sc_per_chip", numScPerChip);
        opBuilder.setAttr("table_name", tableName);
        opBuilder.setAttr("mini_batch_splits", miniBatchSplits);
        return new GetMinibatchSplitsWithPhysicalReplica(opBuilder.build());
    }

    public Output<TInt32> sortedRowIds() {
        return this.sortedRowIds;
    }

    public Output<TInt32> sortedColIds() {
        return this.sortedColIds;
    }

    public Output<TFloat32> sortedGains() {
        return this.sortedGains;
    }

    public Output<TInt64> splits() {
        return this.splits;
    }

    public Output<TInt32> idCounts() {
        return this.idCounts;
    }

    public Output<TInt32> maxIds() {
        return this.maxIds;
    }

    public Output<TInt32> maxUniques() {
        return this.maxUniques;
    }

    @OpInputsMetadata(outputsClass=GetMinibatchSplitsWithPhysicalReplica.class)
    public static class Inputs
    extends RawOpInputs<GetMinibatchSplitsWithPhysicalReplica> {
        public final Operand<TString> programKey;
        public final Operand<TInt32> rowIds;
        public final Operand<TInt32> colIds;
        public final Operand<TFloat32> gains;
        public final long sampleCount;
        public final long numReplica;
        public final long tableVocabSize;
        public final long featureWidth;
        public final long numScPerChip;
        public final String tableName;
        public final String miniBatchSplits;

        public Inputs(GraphOperation op) {
            super(new GetMinibatchSplitsWithPhysicalReplica(op), op, Arrays.asList("sample_count", "num_replica", "table_vocab_size", "feature_width", "num_sc_per_chip", "table_name", "mini_batch_splits"));
            int inputIndex = 0;
            this.programKey = op.input(inputIndex++);
            this.rowIds = op.input(inputIndex++);
            this.colIds = op.input(inputIndex++);
            this.gains = op.input(inputIndex++);
            this.sampleCount = op.attributes().getAttrInt("sample_count");
            this.numReplica = op.attributes().getAttrInt("num_replica");
            this.tableVocabSize = op.attributes().getAttrInt("table_vocab_size");
            this.featureWidth = op.attributes().getAttrInt("feature_width");
            this.numScPerChip = op.attributes().getAttrInt("num_sc_per_chip");
            this.tableName = op.attributes().getAttrString("table_name");
            this.miniBatchSplits = op.attributes().getAttrString("mini_batch_splits");
        }
    }
}

