/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformQuantizedClipByValue", inputsClass=Inputs.class)
public final class UniformQuantizedClipByValue<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "UniformQuantizedClipByValue";
    private Output<T> output;

    public UniformQuantizedClipByValue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> UniformQuantizedClipByValue<T> create(Scope scope, Operand<T> operand, Operand<T> min, Operand<T> max, Operand<TFloat32> scales, Operand<TInt32> zeroPoints, Long quantizationMinVal, Long quantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(operand.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        opBuilder.addInput(scales.asOutput());
        opBuilder.addInput(zeroPoints.asOutput());
        opBuilder.setAttr("quantization_min_val", quantizationMinVal);
        opBuilder.setAttr("quantization_max_val", quantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                if (opts.quantizationAxis == null) continue;
                opBuilder.setAttr("quantization_axis", opts.quantizationAxis);
            }
        }
        return new UniformQuantizedClipByValue<T>(opBuilder.build());
    }

    public static Options quantizationAxis(Long quantizationAxis) {
        return new Options().quantizationAxis(quantizationAxis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformQuantizedClipByValue.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<UniformQuantizedClipByValue<T>> {
        public final Operand<T> operand;
        public final Operand<T> min;
        public final Operand<T> max;
        public final Operand<TFloat32> scales;
        public final Operand<TInt32> zeroPoints;
        public final DataType T;
        public final long quantizationAxis;
        public final long quantizationMinVal;
        public final long quantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformQuantizedClipByValue(op), op, Arrays.asList("T", "quantization_axis", "quantization_min_val", "quantization_max_val"));
            int inputIndex = 0;
            this.operand = op.input(inputIndex++);
            this.min = op.input(inputIndex++);
            this.max = op.input(inputIndex++);
            this.scales = op.input(inputIndex++);
            this.zeroPoints = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.quantizationAxis = op.attributes().getAttrInt("quantization_axis");
            this.quantizationMinVal = op.attributes().getAttrInt("quantization_min_val");
            this.quantizationMaxVal = op.attributes().getAttrInt("quantization_max_val");
        }
    }

    public static class Options {
        private Long quantizationAxis;

        private Options() {
        }

        public Options quantizationAxis(Long quantizationAxis) {
            this.quantizationAxis = quantizationAxis;
            return this;
        }
    }
}

