/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUPartitionedInputV2", inputsClass=Inputs.class)
public final class PartitionedInput<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TPUPartitionedInputV2";
    private Output<T> output;

    public PartitionedInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> PartitionedInput<T> create(Scope scope, Iterable<Operand<T>> inputs, List<Long> partitionDims, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PartitionedInput");
        opBuilder.addInputList(Operands.asOutputs(inputs));
        long[] partitionDimsArray = new long[partitionDims.size()];
        for (int i = 0; i < partitionDimsArray.length; ++i) {
            partitionDimsArray[i] = partitionDims.get(i);
        }
        opBuilder.setAttr("partition_dims", partitionDimsArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.isPacked == null) continue;
                opBuilder.setAttr("is_packed", opts.isPacked);
            }
        }
        return new PartitionedInput<T>(opBuilder.build());
    }

    public static Options isPacked(Boolean isPacked) {
        return new Options().isPacked(isPacked);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=PartitionedInput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<PartitionedInput<T>> {
        public final Iterable<Operand<T>> inputs;
        public final DataType T;
        public final long[] partitionDims;
        public final boolean isPacked;

        public Inputs(GraphOperation op) {
            super(new PartitionedInput(op), op, Arrays.asList("T", "partition_dims", "is_packed"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.T = op.attributes().getAttrType("T");
            this.partitionDims = op.attributes().getAttrIntList("partition_dims");
            this.isPacked = op.attributes().getAttrBool("is_packed");
        }
    }

    public static class Options {
        private Boolean isPacked;

        private Options() {
        }

        public Options isPacked(Boolean isPacked) {
            this.isPacked = isPacked;
            return this;
        }
    }
}

