/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DynamicEnqueueTPUEmbeddingRaggedTensorBatch", inputsClass=Inputs.class)
public final class DynamicEnqueueTPUEmbeddingRaggedTensorBatch
extends RawOp {
    public static final String OP_NAME = "DynamicEnqueueTPUEmbeddingRaggedTensorBatch";

    public DynamicEnqueueTPUEmbeddingRaggedTensorBatch(Operation operation) {
        super(operation, OP_NAME);
    }

    public static DynamicEnqueueTPUEmbeddingRaggedTensorBatch create(Scope scope, Iterable<Operand<? extends TNumber>> sampleSplits, Iterable<Operand<? extends TNumber>> embeddingIndices, Iterable<Operand<? extends TNumber>> aggregationWeights, Operand<TString> modeOverride, Operand<TInt32> deviceOrdinal, List<Long> tableIds, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(sampleSplits));
        opBuilder.addInputList(Operands.asOutputs(embeddingIndices));
        opBuilder.addInputList(Operands.asOutputs(aggregationWeights));
        opBuilder.addInput(modeOverride.asOutput());
        opBuilder.addInput(deviceOrdinal.asOutput());
        long[] tableIdsArray = new long[tableIds.size()];
        for (int i = 0; i < tableIdsArray.length; ++i) {
            tableIdsArray[i] = tableIds.get(i);
        }
        opBuilder.setAttr("table_ids", tableIdsArray);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.combiners != null) {
                    String[] combinersArray = new String[opts.combiners.size()];
                    for (i = 0; i < combinersArray.length; ++i) {
                        combinersArray[i] = opts.combiners.get(i);
                    }
                    opBuilder.setAttr("combiners", combinersArray);
                }
                if (opts.maxSequenceLengths != null) {
                    long[] maxSequenceLengthsArray = new long[opts.maxSequenceLengths.size()];
                    for (i = 0; i < maxSequenceLengthsArray.length; ++i) {
                        maxSequenceLengthsArray[i] = opts.maxSequenceLengths.get(i);
                    }
                    opBuilder.setAttr("max_sequence_lengths", maxSequenceLengthsArray);
                }
                if (opts.numFeatures == null) continue;
                long[] numFeaturesArray = new long[opts.numFeatures.size()];
                for (i = 0; i < numFeaturesArray.length; ++i) {
                    numFeaturesArray[i] = opts.numFeatures.get(i);
                }
                opBuilder.setAttr("num_features", numFeaturesArray);
            }
        }
        return new DynamicEnqueueTPUEmbeddingRaggedTensorBatch(opBuilder.build());
    }

    public static Options combiners(List<String> combiners) {
        return new Options().combiners(combiners);
    }

    public static Options combiners(String ... combiners) {
        return new Options().combiners(combiners);
    }

    public static Options maxSequenceLengths(List<Long> maxSequenceLengths) {
        return new Options().maxSequenceLengths(maxSequenceLengths);
    }

    public static Options maxSequenceLengths(Long ... maxSequenceLengths) {
        return new Options().maxSequenceLengths(maxSequenceLengths);
    }

    public static Options numFeatures(List<Long> numFeatures) {
        return new Options().numFeatures(numFeatures);
    }

    public static Options numFeatures(Long ... numFeatures) {
        return new Options().numFeatures(numFeatures);
    }

    @OpInputsMetadata(outputsClass=DynamicEnqueueTPUEmbeddingRaggedTensorBatch.class)
    public static class Inputs
    extends RawOpInputs<DynamicEnqueueTPUEmbeddingRaggedTensorBatch> {
        public final Iterable<Operand<? extends TNumber>> sampleSplits;
        public final Iterable<Operand<? extends TNumber>> embeddingIndices;
        public final Iterable<Operand<? extends TNumber>> aggregationWeights;
        public final Operand<TString> modeOverride;
        public final Operand<TInt32> deviceOrdinal;
        public final DataType T1;
        public final DataType T2;
        public final DataType T3;
        public final String[] combiners;
        public final long[] tableIds;
        public final long[] maxSequenceLengths;
        public final long[] numFeatures;

        public Inputs(GraphOperation op) {
            super(new DynamicEnqueueTPUEmbeddingRaggedTensorBatch(op), op, Arrays.asList("T1", "T2", "T3", "combiners", "table_ids", "max_sequence_lengths", "num_features"));
            int inputIndex = 0;
            int sampleSplitsLength = op.inputListLength("sample_splits");
            this.sampleSplits = Arrays.asList((Operand[])op.inputList(inputIndex, sampleSplitsLength));
            int embeddingIndicesLength = op.inputListLength("embedding_indices");
            this.embeddingIndices = Arrays.asList((Operand[])op.inputList(inputIndex += sampleSplitsLength, embeddingIndicesLength));
            int aggregationWeightsLength = op.inputListLength("aggregation_weights");
            this.aggregationWeights = Arrays.asList((Operand[])op.inputList(inputIndex += embeddingIndicesLength, aggregationWeightsLength));
            inputIndex += aggregationWeightsLength;
            this.modeOverride = op.input(inputIndex++);
            this.deviceOrdinal = op.input(inputIndex++);
            this.T1 = op.attributes().getAttrType("T1");
            this.T2 = op.attributes().getAttrType("T2");
            this.T3 = op.attributes().getAttrType("T3");
            this.combiners = op.attributes().getAttrStringList("combiners");
            this.tableIds = op.attributes().getAttrIntList("table_ids");
            this.maxSequenceLengths = op.attributes().getAttrIntList("max_sequence_lengths");
            this.numFeatures = op.attributes().getAttrIntList("num_features");
        }
    }

    public static class Options {
        private List<String> combiners;
        private List<Long> maxSequenceLengths;
        private List<Long> numFeatures;

        private Options() {
        }

        public Options combiners(List<String> combiners) {
            this.combiners = combiners;
            return this;
        }

        public Options combiners(String ... combiners) {
            this.combiners = Arrays.asList(combiners);
            return this;
        }

        public Options maxSequenceLengths(List<Long> maxSequenceLengths) {
            this.maxSequenceLengths = maxSequenceLengths;
            return this;
        }

        public Options maxSequenceLengths(Long ... maxSequenceLengths) {
            this.maxSequenceLengths = Arrays.asList(maxSequenceLengths);
            return this;
        }

        public Options numFeatures(List<Long> numFeatures) {
            this.numFeatures = numFeatures;
            return this;
        }

        public Options numFeatures(Long ... numFeatures) {
            this.numFeatures = Arrays.asList(numFeatures);
            return this;
        }
    }
}

