/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseTensorDenseAdd", inputsClass=Inputs.class)
public final class SparseTensorDenseAdd<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SparseTensorDenseAdd";
    private Output<U> output;

    public SparseTensorDenseAdd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType, T extends TNumber> SparseTensorDenseAdd<U> create(Scope scope, Operand<T> aIndices, Operand<U> aValues, Operand<T> aShape, Operand<U> b) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(aIndices.asOutput());
        opBuilder.addInput(aValues.asOutput());
        opBuilder.addInput(aShape.asOutput());
        opBuilder.addInput(b.asOutput());
        return new SparseTensorDenseAdd<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseTensorDenseAdd.class)
    public static class Inputs<T extends TNumber, U extends TType>
    extends RawOpInputs<SparseTensorDenseAdd<U>> {
        public final Operand<T> aIndices;
        public final Operand<U> aValues;
        public final Operand<T> aShape;
        public final Operand<U> b;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new SparseTensorDenseAdd(op), op, Arrays.asList("T", "Tindices"));
            int inputIndex = 0;
            this.aIndices = op.input(inputIndex++);
            this.aValues = op.input(inputIndex++);
            this.aShape = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

