/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SparseBincount", inputsClass=Inputs.class)
public final class SparseBincount<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SparseBincount";
    private Output<U> output;

    public SparseBincount(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber, T extends TNumber> SparseBincount<U> create(Scope scope, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> denseShape, Operand<T> sizeOutput, Operand<U> weights, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(denseShape.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        opBuilder.addInput(weights.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.binaryOutput == null) continue;
                opBuilder.setAttr("binary_output", opts.binaryOutput);
            }
        }
        return new SparseBincount<U>(opBuilder.build());
    }

    public static Options binaryOutput(Boolean binaryOutput) {
        return new Options().binaryOutput(binaryOutput);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseBincount.class)
    public static class Inputs<T extends TNumber, U extends TNumber>
    extends RawOpInputs<SparseBincount<U>> {
        public final Operand<TInt64> indices;
        public final Operand<T> values;
        public final Operand<TInt64> denseShape;
        public final Operand<T> sizeOutput;
        public final Operand<U> weights;
        public final DataType Tidx;
        public final DataType T;
        public final boolean binaryOutput;

        public Inputs(GraphOperation op) {
            super(new SparseBincount(op), op, Arrays.asList("Tidx", "T", "binary_output"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.denseShape = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.weights = op.input(inputIndex++);
            this.Tidx = op.attributes().getAttrType("Tidx");
            this.T = op.attributes().getAttrType("T");
            this.binaryOutput = op.attributes().getAttrBool("binary_output");
        }
    }

    public static class Options {
        private Boolean binaryOutput;

        private Options() {
        }

        public Options binaryOutput(Boolean binaryOutput) {
            this.binaryOutput = binaryOutput;
            return this;
        }
    }
}

