/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="LSTMBlockCellGrad", inputsClass=Inputs.class)
public final class LSTMBlockCellGrad<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "LSTMBlockCellGrad";
    private Output<T> csPrevGrad;
    private Output<T> dicfo;
    private Output<T> wciGrad;
    private Output<T> wcfGrad;
    private Output<T> wcoGrad;

    public LSTMBlockCellGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.csPrevGrad = operation.output(outputIdx++);
        this.dicfo = operation.output(outputIdx++);
        this.wciGrad = operation.output(outputIdx++);
        this.wcfGrad = operation.output(outputIdx++);
        this.wcoGrad = operation.output(outputIdx++);
    }

    public static <T extends TNumber> LSTMBlockCellGrad<T> create(Scope scope, Operand<T> x, Operand<T> csPrev, Operand<T> hPrev, Operand<T> w, Operand<T> wci, Operand<T> wcf, Operand<T> wco, Operand<T> b, Operand<T> i, Operand<T> cs, Operand<T> f, Operand<T> o, Operand<T> ci, Operand<T> co, Operand<T> csGrad, Operand<T> hGrad, Boolean usePeephole) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(csPrev.asOutput());
        opBuilder.addInput(hPrev.asOutput());
        opBuilder.addInput(w.asOutput());
        opBuilder.addInput(wci.asOutput());
        opBuilder.addInput(wcf.asOutput());
        opBuilder.addInput(wco.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(i.asOutput());
        opBuilder.addInput(cs.asOutput());
        opBuilder.addInput(f.asOutput());
        opBuilder.addInput(o.asOutput());
        opBuilder.addInput(ci.asOutput());
        opBuilder.addInput(co.asOutput());
        opBuilder.addInput(csGrad.asOutput());
        opBuilder.addInput(hGrad.asOutput());
        opBuilder.setAttr("use_peephole", usePeephole);
        return new LSTMBlockCellGrad<T>(opBuilder.build());
    }

    public Output<T> csPrevGrad() {
        return this.csPrevGrad;
    }

    public Output<T> dicfo() {
        return this.dicfo;
    }

    public Output<T> wciGrad() {
        return this.wciGrad;
    }

    public Output<T> wcfGrad() {
        return this.wcfGrad;
    }

    public Output<T> wcoGrad() {
        return this.wcoGrad;
    }

    @OpInputsMetadata(outputsClass=LSTMBlockCellGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<LSTMBlockCellGrad<T>> {
        public final Operand<T> x;
        public final Operand<T> csPrev;
        public final Operand<T> hPrev;
        public final Operand<T> w;
        public final Operand<T> wci;
        public final Operand<T> wcf;
        public final Operand<T> wco;
        public final Operand<T> b;
        public final Operand<T> i;
        public final Operand<T> cs;
        public final Operand<T> f;
        public final Operand<T> o;
        public final Operand<T> ci;
        public final Operand<T> co;
        public final Operand<T> csGrad;
        public final Operand<T> hGrad;
        public final boolean usePeephole;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new LSTMBlockCellGrad(op), op, Arrays.asList("use_peephole", "T"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.csPrev = op.input(inputIndex++);
            this.hPrev = op.input(inputIndex++);
            this.w = op.input(inputIndex++);
            this.wci = op.input(inputIndex++);
            this.wcf = op.input(inputIndex++);
            this.wco = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.i = op.input(inputIndex++);
            this.cs = op.input(inputIndex++);
            this.f = op.input(inputIndex++);
            this.o = op.input(inputIndex++);
            this.ci = op.input(inputIndex++);
            this.co = op.input(inputIndex++);
            this.csGrad = op.input(inputIndex++);
            this.hGrad = op.input(inputIndex++);
            this.usePeephole = op.attributes().getAttrBool("use_peephole");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

