/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaRecvTPUEmbeddingActivations", inputsClass=Inputs.class)
public final class XlaRecvTPUEmbeddingActivations
extends RawOp
implements Iterable<Operand<TFloat32>> {
    public static final String OP_NAME = "XlaRecvTPUEmbeddingActivations";
    private List<Output<TFloat32>> outputs;

    public XlaRecvTPUEmbeddingActivations(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static XlaRecvTPUEmbeddingActivations create(Scope scope, Operand<? extends TType> deduplicationData, Long numTables, String config) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(deduplicationData.asOutput());
        opBuilder.setAttr("num_tables", numTables);
        opBuilder.setAttr("config", config);
        return new XlaRecvTPUEmbeddingActivations(opBuilder.build());
    }

    public List<Output<TFloat32>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TFloat32>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaRecvTPUEmbeddingActivations.class)
    public static class Inputs
    extends RawOpInputs<XlaRecvTPUEmbeddingActivations> {
        public final Operand<? extends TType> deduplicationData;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new XlaRecvTPUEmbeddingActivations(op), op, Arrays.asList("config"));
            int inputIndex = 0;
            this.deduplicationData = op.input(inputIndex++);
            this.config = op.attributes().getAttrString("config");
        }
    }
}

