/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;

@OpMetadata(opType="DTensorShardedPrefix", inputsClass=Inputs.class)
public final class DTensorShardedPrefix
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "DTensorShardedPrefix";
    private Output<TString> output;

    public DTensorShardedPrefix(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static DTensorShardedPrefix create(Scope scope, Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, Operand<TString> mesh, Operand<TString> layouts, Iterable<Operand<?>> tensors) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(prefix.asOutput());
        opBuilder.addInput(tensorNames.asOutput());
        opBuilder.addInput(shapeAndSlices.asOutput());
        opBuilder.addInput(mesh.asOutput());
        opBuilder.addInput(layouts.asOutput());
        opBuilder.addInputList(Operands.asOutputs(tensors));
        return new DTensorShardedPrefix(opBuilder.build());
    }

    public Output<TString> output() {
        return this.output;
    }

    @Override
    public Output<TString> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DTensorShardedPrefix.class)
    public static class Inputs
    extends RawOpInputs<DTensorShardedPrefix> {
        public final Operand<TString> prefix;
        public final Operand<TString> tensorNames;
        public final Operand<TString> shapeAndSlices;
        public final Operand<TString> mesh;
        public final Operand<TString> layouts;
        public final Iterable<Operand<?>> tensors;
        public final DataType[] dtypes;

        public Inputs(GraphOperation op) {
            super(new DTensorShardedPrefix(op), op, Arrays.asList("dtypes"));
            int inputIndex = 0;
            this.prefix = op.input(inputIndex++);
            this.tensorNames = op.input(inputIndex++);
            this.shapeAndSlices = op.input(inputIndex++);
            this.mesh = op.input(inputIndex++);
            this.layouts = op.input(inputIndex++);
            int tensorsLength = op.inputListLength("tensors");
            this.tensors = Arrays.asList((Operand[])op.inputList(inputIndex, tensorsLength));
            inputIndex += tensorsLength;
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
        }
    }
}

