/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RiscSqueeze", inputsClass=Inputs.class)
public final class RiscSqueeze<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscSqueeze";
    private Output<T> output;

    public RiscSqueeze(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> RiscSqueeze<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.squeezeDims == null) continue;
                long[] squeezeDimsArray = new long[opts.squeezeDims.size()];
                for (int i = 0; i < squeezeDimsArray.length; ++i) {
                    squeezeDimsArray[i] = opts.squeezeDims.get(i);
                }
                opBuilder.setAttr("squeeze_dims", squeezeDimsArray);
            }
        }
        return new RiscSqueeze<T>(opBuilder.build());
    }

    public static Options squeezeDims(List<Long> squeezeDims) {
        return new Options().squeezeDims(squeezeDims);
    }

    public static Options squeezeDims(Long ... squeezeDims) {
        return new Options().squeezeDims(squeezeDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscSqueeze.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<RiscSqueeze<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final long[] squeezeDims;

        public Inputs(GraphOperation op) {
            super(new RiscSqueeze(op), op, Arrays.asList("T", "squeeze_dims"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.squeezeDims = op.attributes().getAttrIntList("squeeze_dims");
        }
    }

    public static class Options {
        private List<Long> squeezeDims;

        private Options() {
        }

        public Options squeezeDims(List<Long> squeezeDims) {
            this.squeezeDims = squeezeDims;
            return this;
        }

        public Options squeezeDims(Long ... squeezeDims) {
            this.squeezeDims = Arrays.asList(squeezeDims);
            return this;
        }
    }
}

