/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedTensorToVariant", inputsClass=Inputs.class)
public final class RaggedTensorToVariant
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "RaggedTensorToVariant";
    private Output<? extends TType> encodedRagged;

    public RaggedTensorToVariant(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.encodedRagged = operation.output(outputIdx++);
    }

    public static RaggedTensorToVariant create(Scope scope, Iterable<Operand<? extends TNumber>> rtNestedSplits, Operand<? extends TType> rtDenseValues, Boolean batchedInput) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(rtNestedSplits));
        opBuilder.addInput(rtDenseValues.asOutput());
        opBuilder.setAttr("batched_input", batchedInput);
        return new RaggedTensorToVariant(opBuilder.build());
    }

    public Output<? extends TType> encodedRagged() {
        return this.encodedRagged;
    }

    @Override
    public Output<TType> asOutput() {
        return this.encodedRagged;
    }

    @OpInputsMetadata(outputsClass=RaggedTensorToVariant.class)
    public static class Inputs
    extends RawOpInputs<RaggedTensorToVariant> {
        public final Iterable<Operand<? extends TNumber>> rtNestedSplits;
        public final Operand<? extends TType> rtDenseValues;
        public final DataType Tvalues;
        public final DataType Tsplits;
        public final boolean batchedInput;

        public Inputs(GraphOperation op) {
            super(new RaggedTensorToVariant(op), op, Arrays.asList("Tvalues", "Tsplits", "batched_input"));
            int inputIndex = 0;
            int rtNestedSplitsLength = op.inputListLength("rt_nested_splits");
            this.rtNestedSplits = Arrays.asList((Operand[])op.inputList(inputIndex, rtNestedSplitsLength));
            inputIndex += rtNestedSplitsLength;
            this.rtDenseValues = op.input(inputIndex++);
            this.Tvalues = op.attributes().getAttrType("Tvalues");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
            this.batchedInput = op.attributes().getAttrBool("batched_input");
        }
    }
}

