/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SerializeManySparse", inputsClass=Inputs.class)
public final class SerializeManySparse<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SerializeManySparse";
    private Output<U> serializedSparse;

    public SerializeManySparse(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.serializedSparse = operation.output(outputIdx++);
    }

    public static <U extends TType> SerializeManySparse<U> create(Scope scope, Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape, Class<U> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(sparseShape.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new SerializeManySparse<U>(opBuilder.build());
    }

    public static SerializeManySparse<TString> create(Scope scope, Operand<TInt64> sparseIndices, Operand<? extends TType> sparseValues, Operand<TInt64> sparseShape) {
        return SerializeManySparse.create(scope, sparseIndices, sparseValues, sparseShape, TString.class);
    }

    public Output<U> serializedSparse() {
        return this.serializedSparse;
    }

    @Override
    public Output<U> asOutput() {
        return this.serializedSparse;
    }

    @OpInputsMetadata(outputsClass=SerializeManySparse.class)
    public static class Inputs
    extends RawOpInputs<SerializeManySparse<?>> {
        public final Operand<TInt64> sparseIndices;
        public final Operand<? extends TType> sparseValues;
        public final Operand<TInt64> sparseShape;
        public final DataType T;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new SerializeManySparse(op), op, Arrays.asList("T", "out_type"));
            int inputIndex = 0;
            this.sparseIndices = op.input(inputIndex++);
            this.sparseValues = op.input(inputIndex++);
            this.sparseShape = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

