/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RandomShuffleQueueV2", inputsClass=Inputs.class)
public final class RandomShuffleQueue
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "RandomShuffleQueueV2";
    private Output<? extends TType> handle;

    public RandomShuffleQueue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static RandomShuffleQueue create(Scope scope, List<Class<? extends TType>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "RandomShuffleQueue");
        opBuilder.setAttr("component_types", Operands.toDataTypes(componentTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.shapes != null) {
                    Shape[] shapesArray = new Shape[opts.shapes.size()];
                    for (int i = 0; i < shapesArray.length; ++i) {
                        shapesArray[i] = opts.shapes.get(i);
                    }
                    opBuilder.setAttr("shapes", shapesArray);
                }
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.minAfterDequeue != null) {
                    opBuilder.setAttr("min_after_dequeue", opts.minAfterDequeue);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new RandomShuffleQueue(opBuilder.build());
    }

    public static Options shapes(List<Shape> shapes) {
        return new Options().shapes(shapes);
    }

    public static Options shapes(Shape ... shapes) {
        return new Options().shapes(shapes);
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options minAfterDequeue(Long minAfterDequeue) {
        return new Options().minAfterDequeue(minAfterDequeue);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=RandomShuffleQueue.class)
    public static class Inputs
    extends RawOpInputs<RandomShuffleQueue> {
        public final DataType[] componentTypes;
        public final Shape[] shapes;
        public final long capacity;
        public final long minAfterDequeue;
        public final long seed;
        public final long seed2;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new RandomShuffleQueue(op), op, Arrays.asList("component_types", "shapes", "capacity", "min_after_dequeue", "seed", "seed2", "container", "shared_name"));
            boolean inputIndex = false;
            this.componentTypes = op.attributes().getAttrTypeList("component_types");
            this.shapes = op.attributes().getAttrShapeList("shapes");
            this.capacity = op.attributes().getAttrInt("capacity");
            this.minAfterDequeue = op.attributes().getAttrInt("min_after_dequeue");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private List<Shape> shapes;
        private Long capacity;
        private Long minAfterDequeue;
        private Long seed;
        private Long seed2;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options shapes(List<Shape> shapes) {
            this.shapes = shapes;
            return this;
        }

        public Options shapes(Shape ... shapes) {
            this.shapes = Arrays.asList(shapes);
            return this;
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options minAfterDequeue(Long minAfterDequeue) {
            this.minAfterDequeue = minAfterDequeue;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

