/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="StatelessSampleDistortedBoundingBox", inputsClass=Inputs.class)
public final class StatelessSampleDistortedBoundingBox<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "StatelessSampleDistortedBoundingBox";
    private Output<T> begin;
    private Output<T> sizeOutput;
    private Output<TFloat32> bboxes;

    public StatelessSampleDistortedBoundingBox(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.begin = operation.output(outputIdx++);
        this.sizeOutput = operation.output(outputIdx++);
        this.bboxes = operation.output(outputIdx++);
    }

    public static <T extends TNumber> StatelessSampleDistortedBoundingBox<T> create(Scope scope, Operand<T> imageSize, Operand<TFloat32> boundingBoxes, Operand<TFloat32> minObjectCovered, Operand<? extends TNumber> seed, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(imageSize.asOutput());
        opBuilder.addInput(boundingBoxes.asOutput());
        opBuilder.addInput(minObjectCovered.asOutput());
        opBuilder.addInput(seed.asOutput());
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.aspectRatioRange != null) {
                    float[] aspectRatioRangeArray = new float[opts.aspectRatioRange.size()];
                    for (i = 0; i < aspectRatioRangeArray.length; ++i) {
                        aspectRatioRangeArray[i] = opts.aspectRatioRange.get(i).floatValue();
                    }
                    opBuilder.setAttr("aspect_ratio_range", aspectRatioRangeArray);
                }
                if (opts.areaRange != null) {
                    float[] areaRangeArray = new float[opts.areaRange.size()];
                    for (i = 0; i < areaRangeArray.length; ++i) {
                        areaRangeArray[i] = opts.areaRange.get(i).floatValue();
                    }
                    opBuilder.setAttr("area_range", areaRangeArray);
                }
                if (opts.maxAttempts != null) {
                    opBuilder.setAttr("max_attempts", opts.maxAttempts);
                }
                if (opts.useImageIfNoBoundingBoxes == null) continue;
                opBuilder.setAttr("use_image_if_no_bounding_boxes", opts.useImageIfNoBoundingBoxes);
            }
        }
        return new StatelessSampleDistortedBoundingBox<T>(opBuilder.build());
    }

    public static Options aspectRatioRange(List<Float> aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options aspectRatioRange(Float ... aspectRatioRange) {
        return new Options().aspectRatioRange(aspectRatioRange);
    }

    public static Options areaRange(List<Float> areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options areaRange(Float ... areaRange) {
        return new Options().areaRange(areaRange);
    }

    public static Options maxAttempts(Long maxAttempts) {
        return new Options().maxAttempts(maxAttempts);
    }

    public static Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
        return new Options().useImageIfNoBoundingBoxes(useImageIfNoBoundingBoxes);
    }

    public Output<T> begin() {
        return this.begin;
    }

    public Output<T> sizeOutput() {
        return this.sizeOutput;
    }

    public Output<TFloat32> bboxes() {
        return this.bboxes;
    }

    @OpInputsMetadata(outputsClass=StatelessSampleDistortedBoundingBox.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<StatelessSampleDistortedBoundingBox<T>> {
        public final Operand<T> imageSize;
        public final Operand<TFloat32> boundingBoxes;
        public final Operand<TFloat32> minObjectCovered;
        public final Operand<? extends TNumber> seed;
        public final DataType T;
        public final DataType Tseed;
        public final float[] aspectRatioRange;
        public final float[] areaRange;
        public final long maxAttempts;
        public final boolean useImageIfNoBoundingBoxes;

        public Inputs(GraphOperation op) {
            super(new StatelessSampleDistortedBoundingBox(op), op, Arrays.asList("T", "Tseed", "aspect_ratio_range", "area_range", "max_attempts", "use_image_if_no_bounding_boxes"));
            int inputIndex = 0;
            this.imageSize = op.input(inputIndex++);
            this.boundingBoxes = op.input(inputIndex++);
            this.minObjectCovered = op.input(inputIndex++);
            this.seed = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tseed = op.attributes().getAttrType("Tseed");
            this.aspectRatioRange = op.attributes().getAttrFloatList("aspect_ratio_range");
            this.areaRange = op.attributes().getAttrFloatList("area_range");
            this.maxAttempts = op.attributes().getAttrInt("max_attempts");
            this.useImageIfNoBoundingBoxes = op.attributes().getAttrBool("use_image_if_no_bounding_boxes");
        }
    }

    public static class Options {
        private List<Float> aspectRatioRange;
        private List<Float> areaRange;
        private Long maxAttempts;
        private Boolean useImageIfNoBoundingBoxes;

        private Options() {
        }

        public Options aspectRatioRange(List<Float> aspectRatioRange) {
            this.aspectRatioRange = aspectRatioRange;
            return this;
        }

        public Options aspectRatioRange(Float ... aspectRatioRange) {
            this.aspectRatioRange = Arrays.asList(aspectRatioRange);
            return this;
        }

        public Options areaRange(List<Float> areaRange) {
            this.areaRange = areaRange;
            return this;
        }

        public Options areaRange(Float ... areaRange) {
            this.areaRange = Arrays.asList(areaRange);
            return this;
        }

        public Options maxAttempts(Long maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Options useImageIfNoBoundingBoxes(Boolean useImageIfNoBoundingBoxes) {
            this.useImageIfNoBoundingBoxes = useImageIfNoBoundingBoxes;
            return this;
        }
    }
}

