/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CopyToMesh", inputsClass=Inputs.class)
public final class CopyToMesh<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CopyToMesh";
    private Output<T> output;

    public CopyToMesh(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> CopyToMesh<T> create(Scope scope, Operand<T> input, String layout, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("layout", layout);
        if (options != null) {
            for (Options opts : options) {
                if (opts.sourceLayout == null) continue;
                opBuilder.setAttr("source_layout", opts.sourceLayout);
            }
        }
        return new CopyToMesh<T>(opBuilder.build());
    }

    public static Options sourceLayout(String sourceLayout) {
        return new Options().sourceLayout(sourceLayout);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=CopyToMesh.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<CopyToMesh<T>> {
        public final Operand<T> input;
        public final String layout;
        public final String sourceLayout;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new CopyToMesh(op), op, Arrays.asList("layout", "source_layout", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.layout = op.attributes().getAttrString("layout");
            this.sourceLayout = op.attributes().getAttrString("source_layout");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String sourceLayout;

        private Options() {
        }

        public Options sourceLayout(String sourceLayout) {
            this.sourceLayout = sourceLayout;
            return this;
        }
    }
}

