/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.xla.AllReduce;
import org.tensorflow.op.xla.BroadcastHelper;
import org.tensorflow.op.xla.ClusterOutput;
import org.tensorflow.op.xla.Conv;
import org.tensorflow.op.xla.CustomCall;
import org.tensorflow.op.xla.Dequantize;
import org.tensorflow.op.xla.Dot;
import org.tensorflow.op.xla.DynamicSlice;
import org.tensorflow.op.xla.DynamicUpdateSlice;
import org.tensorflow.op.xla.Einsum;
import org.tensorflow.op.xla.Gather;
import org.tensorflow.op.xla.If;
import org.tensorflow.op.xla.KeyValueSort;
import org.tensorflow.op.xla.OptimizationBarrier;
import org.tensorflow.op.xla.Pad;
import org.tensorflow.op.xla.Recv;
import org.tensorflow.op.xla.Reduce;
import org.tensorflow.op.xla.ReduceScatter;
import org.tensorflow.op.xla.ReduceWindow;
import org.tensorflow.op.xla.RemoveDynamicDimensionSize;
import org.tensorflow.op.xla.ReplicaId;
import org.tensorflow.op.xla.RngBitGenerator;
import org.tensorflow.op.xla.Scatter;
import org.tensorflow.op.xla.SelectAndScatter;
import org.tensorflow.op.xla.SelfAdjointEig;
import org.tensorflow.op.xla.Send;
import org.tensorflow.op.xla.SetDynamicDimensionSize;
import org.tensorflow.op.xla.Sharding;
import org.tensorflow.op.xla.Sort;
import org.tensorflow.op.xla.SpmdFullToShardShape;
import org.tensorflow.op.xla.SpmdShardToFullShape;
import org.tensorflow.op.xla.Svd;
import org.tensorflow.op.xla.While;
import org.tensorflow.op.xla.XlaHostCompute;
import org.tensorflow.op.xla.XlaLaunch;
import org.tensorflow.op.xla.XlaRecvFromHost;
import org.tensorflow.op.xla.XlaSendToHost;
import org.tensorflow.op.xla.XlaSetBound;
import org.tensorflow.op.xla.XlaVariadicReduce;
import org.tensorflow.op.xla.XlaVariadicSort;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class XlaOps {
    private final Scope scope;
    private final Ops ops;

    XlaOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TNumber> AllReduce<T> allReduce(Operand<T> input, Operand<TInt32> groupAssignment, String reduceOp, String mode) {
        return AllReduce.create(this.scope, input, groupAssignment, reduceOp, mode);
    }

    public <T extends TType> BroadcastHelper<T> broadcastHelper(Operand<T> lhs, Operand<T> rhs, Operand<? extends TNumber> broadcastDims) {
        return BroadcastHelper.create(this.scope, lhs, rhs, broadcastDims);
    }

    public <T extends TType> ClusterOutput<T> clusterOutput(Operand<T> input) {
        return ClusterOutput.create(this.scope, input);
    }

    public <W extends TType, V extends TNumber> Conv<W> conv(Operand<? extends TType> lhs, Operand<? extends TType> rhs, Operand<V> windowStrides, Operand<V> padding, Operand<V> lhsDilation, Operand<V> rhsDilation, Operand<V> featureGroupCount, String dimensionNumbers, String precisionConfig, Class<W> preferredElementType, Conv.Options ... options) {
        return Conv.create(this.scope, lhs, rhs, windowStrides, padding, lhsDilation, rhsDilation, featureGroupCount, dimensionNumbers, precisionConfig, preferredElementType, options);
    }

    public <T extends TType> CustomCall<T> customCall(Iterable<Operand<?>> args, String targetName, String backendConfig, Class<T> dtype, Shape shape) {
        return CustomCall.create(this.scope, args, targetName, backendConfig, dtype, shape);
    }

    public Dequantize dequantize(Operand<? extends TType> input, Float minRange, Float maxRange, String mode, Boolean transposeOutput) {
        return Dequantize.create(this.scope, input, minRange, maxRange, mode, transposeOutput);
    }

    public <V extends TType> Dot<V> dot(Operand<? extends TType> lhs, Operand<? extends TType> rhs, String dimensionNumbers, String precisionConfig, Class<V> preferredElementType) {
        return Dot.create(this.scope, lhs, rhs, dimensionNumbers, precisionConfig, preferredElementType);
    }

    public <T extends TType, U extends TNumber> DynamicSlice<T> dynamicSlice(Operand<T> input, Operand<U> startIndices, Operand<U> sizeIndices) {
        return DynamicSlice.create(this.scope, input, startIndices, sizeIndices);
    }

    public <T extends TType> DynamicUpdateSlice<T> dynamicUpdateSlice(Operand<T> input, Operand<T> update, Operand<? extends TNumber> indices) {
        return DynamicUpdateSlice.create(this.scope, input, update, indices);
    }

    public <T extends TType> Einsum<T> einsum(Operand<T> a, Operand<T> b, String equation) {
        return Einsum.create(this.scope, a, b, equation);
    }

    public <T extends TType, U extends TNumber> Gather<T> gather(Operand<T> operand, Operand<U> startIndices, Operand<U> sliceSizes, String dimensionNumbers, Boolean indicesAreSorted) {
        return Gather.create(this.scope, operand, startIndices, sliceSizes, dimensionNumbers, indicesAreSorted);
    }

    public If ifOp(Operand<? extends TType> cond, Iterable<Operand<?>> inputs, ConcreteFunction thenBranch, ConcreteFunction elseBranch, List<Class<? extends TType>> Tout) {
        return If.create(this.scope, cond, inputs, thenBranch, elseBranch, Tout);
    }

    public <T extends TNumber, U extends TType> KeyValueSort<T, U> keyValueSort(Operand<T> keys, Operand<U> values) {
        return KeyValueSort.create(this.scope, keys, values);
    }

    public OptimizationBarrier optimizationBarrier(Iterable<Operand<?>> input) {
        return OptimizationBarrier.create(this.scope, input);
    }

    public <T extends TType, U extends TNumber> Pad<T> pad(Operand<T> input, Operand<T> paddingValue, Operand<U> paddingLow, Operand<U> paddingHigh, Operand<U> paddingInterior) {
        return Pad.create(this.scope, input, paddingValue, paddingLow, paddingHigh, paddingInterior);
    }

    public <T extends TType> Recv<T> recv(Class<T> dtype, String tensorName, Shape shape) {
        return Recv.create(this.scope, dtype, tensorName, shape);
    }

    public <T extends TType> Reduce<T> reduce(Operand<T> input, Operand<T> initValue, List<Long> dimensionsToReduce, ConcreteFunction reducer) {
        return Reduce.create(this.scope, input, initValue, dimensionsToReduce, reducer);
    }

    public <T extends TNumber> ReduceScatter<T> reduceScatter(Operand<T> input, Operand<TInt32> groupAssignment, Operand<TInt32> scatterDimension, String reduceOp) {
        return ReduceScatter.create(this.scope, input, groupAssignment, scatterDimension, reduceOp);
    }

    public <T extends TType, U extends TNumber> ReduceWindow<T> reduceWindow(Operand<T> input, Operand<T> initValue, Operand<U> windowDimensions, Operand<U> windowStrides, Operand<U> baseDilations, Operand<U> windowDilations, Operand<U> padding, ConcreteFunction computation) {
        return ReduceWindow.create(this.scope, input, initValue, windowDimensions, windowStrides, baseDilations, windowDilations, padding, computation);
    }

    public <T extends TType> RemoveDynamicDimensionSize<T> removeDynamicDimensionSize(Operand<T> input, Operand<TInt32> dimIndex) {
        return RemoveDynamicDimensionSize.create(this.scope, input, dimIndex);
    }

    public ReplicaId replicaId() {
        return ReplicaId.create(this.scope);
    }

    public <U extends TNumber> RngBitGenerator<U> rngBitGenerator(Operand<TInt32> algorithm, Operand<? extends TType> initialState, Operand<? extends TNumber> shape, Class<U> dtype) {
        return RngBitGenerator.create(this.scope, algorithm, initialState, shape, dtype);
    }

    public <T extends TType> Scatter<T> scatter(Operand<T> operand, Operand<? extends TNumber> scatterIndices, Operand<T> updates, ConcreteFunction updateComputation, String dimensionNumbers, Boolean indicesAreSorted) {
        return Scatter.create(this.scope, operand, scatterIndices, updates, updateComputation, dimensionNumbers, indicesAreSorted);
    }

    public <T extends TType, U extends TNumber> SelectAndScatter<T> selectAndScatter(Operand<T> operand, Operand<U> windowDimensions, Operand<U> windowStrides, Operand<U> padding, Operand<T> source, Operand<T> initValue, ConcreteFunction select, ConcreteFunction scatter) {
        return SelectAndScatter.create(this.scope, operand, windowDimensions, windowStrides, padding, source, initValue, select, scatter);
    }

    public <T extends TType> SelfAdjointEig<T> selfAdjointEig(Operand<T> a, Boolean lower, Long maxIter, Float epsilon) {
        return SelfAdjointEig.create(this.scope, a, lower, maxIter, epsilon);
    }

    public Send send(Operand<? extends TType> tensor, String tensorName) {
        return Send.create(this.scope, tensor, tensorName);
    }

    public <T extends TType> SetDynamicDimensionSize<T> setDynamicDimensionSize(Operand<T> input, Operand<TInt32> dimIndex, Operand<TInt32> sizeOutput) {
        return SetDynamicDimensionSize.create(this.scope, input, dimIndex, sizeOutput);
    }

    public <T extends TType> Sharding<T> sharding(Operand<T> input, Sharding.Options ... options) {
        return Sharding.create(this.scope, input, options);
    }

    public <T extends TType> Sort<T> sort(Operand<T> input) {
        return Sort.create(this.scope, input);
    }

    public <T extends TType> SpmdFullToShardShape<T> spmdFullToShardShape(Operand<T> input, String manualSharding, SpmdFullToShardShape.Options ... options) {
        return SpmdFullToShardShape.create(this.scope, input, manualSharding, options);
    }

    public <T extends TType> SpmdShardToFullShape<T> spmdShardToFullShape(Operand<T> input, String manualSharding, Shape fullShape, SpmdShardToFullShape.Options ... options) {
        return SpmdShardToFullShape.create(this.scope, input, manualSharding, fullShape, options);
    }

    public <T extends TType> Svd<T> svd(Operand<T> a, Long maxIter, Float epsilon, String precisionConfig) {
        return Svd.create(this.scope, a, maxIter, epsilon, precisionConfig);
    }

    public While whileOp(Iterable<Operand<?>> input, ConcreteFunction cond, ConcreteFunction body) {
        return While.create(this.scope, input, cond, body);
    }

    public XlaHostCompute xlaHostCompute(Iterable<Operand<?>> inputs, List<Class<? extends TType>> Toutputs, List<String> ancestors, List<Shape> shapes, ConcreteFunction shapeInferenceGraph, String key, XlaHostCompute.Options ... options) {
        return XlaHostCompute.create(this.scope, inputs, Toutputs, ancestors, shapes, shapeInferenceGraph, key, options);
    }

    public XlaLaunch xlaLaunch(Iterable<Operand<?>> constants, Iterable<Operand<?>> args, Iterable<Operand<? extends TType>> resources, List<Class<? extends TType>> Tresults, ConcreteFunction function) {
        return XlaLaunch.create(this.scope, constants, args, resources, Tresults, function);
    }

    public <T extends TType> XlaRecvFromHost<T> xlaRecvFromHost(Class<T> Toutput, Shape shape, String key) {
        return XlaRecvFromHost.create(this.scope, Toutput, shape, key);
    }

    public XlaSendToHost xlaSendToHost(Operand<? extends TType> input, String key) {
        return XlaSendToHost.create(this.scope, input, key);
    }

    public XlaSetBound xlaSetBound(Operand<TInt32> input, Operand<TInt32> bound) {
        return XlaSetBound.create(this.scope, input, bound);
    }

    public XlaVariadicReduce xlaVariadicReduce(Iterable<Operand<?>> inputs, Iterable<Operand<?>> initValues, List<Long> dimensionsToReduce, ConcreteFunction reducer) {
        return XlaVariadicReduce.create(this.scope, inputs, initValues, dimensionsToReduce, reducer);
    }

    public XlaVariadicSort xlaVariadicSort(Iterable<Operand<?>> inputs, Operand<TInt32> dimension, ConcreteFunction comparator, Boolean isStable) {
        return XlaVariadicSort.create(this.scope, inputs, dimension, comparator, isStable);
    }

    public final Ops ops() {
        return this.ops;
    }
}

