/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.sequence;

import java.util.PrimitiveIterator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.ndarray.impl.sequence.IndexedPositionIterator;
import org.tensorflow.ndarray.impl.sequence.IndexedSequentialPositionIterator;
import org.tensorflow.ndarray.impl.sequence.NdPositionIterator;
import org.tensorflow.ndarray.impl.sequence.SequentialPositionIterator;

public interface PositionIterator
extends PrimitiveIterator.OfLong {
    public static PositionIterator create(DimensionalSpace dimensions, int dimensionIdx) {
        if (dimensions.isSegmented()) {
            return new NdPositionIterator(dimensions, dimensionIdx);
        }
        return new SequentialPositionIterator(dimensions, dimensionIdx);
    }

    public static IndexedPositionIterator createIndexed(DimensionalSpace dimensions, int dimensionIdx) {
        if (dimensions.isSegmented()) {
            return new NdPositionIterator(dimensions, dimensionIdx);
        }
        return new IndexedSequentialPositionIterator(dimensions, dimensionIdx);
    }

    public static PositionIterator sequence(long stride, long end) {
        return new SequentialPositionIterator(stride, end);
    }
}

