/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.adapter;

import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.layout.LongDataLayout;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.adapter.AbstractDataBufferAdapter;

class LongDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Long, LongDataBuffer>
implements LongDataBuffer {
    private LongDataLayout<S> layout;

    @Override
    public long getLong(long index) {
        Validator.getArgs(this, index);
        return this.layout.readLong(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public LongDataBuffer setLong(long value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeLong(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public LongDataBuffer read(long[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readLong(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public LongDataBuffer write(long[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeLong(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public LongDataBuffer copyTo(DataBuffer<Long> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof LongDataBuffer) {
            LongDataBuffer longDst = (LongDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                longDst.setLong(this.getLong(idx), idx);
            }
            return this;
        }
        return (LongDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public LongDataBuffer offset(long index) {
        return new LongDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public LongDataBuffer narrow(long size) {
        return new LongDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public LongDataBuffer slice(long index, long size) {
        return new LongDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongDataBuffer)) {
            return super.equals(obj);
        }
        LongDataBuffer other = (LongDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getLong(idx) == this.getLong(idx)) continue;
            return false;
        }
        return true;
    }

    LongDataBufferAdapter(S buffer, LongDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

