/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import java.nio.ReadOnlyBufferException;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.internal.buffer.ByteSequenceProvider;
import org.tensorflow.internal.c_api.TF_TString;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.impl.buffer.AbstractDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;

public class ByteSequenceTensorBuffer
extends AbstractDataBuffer<byte[]> {
    private final TF_TString data;

    public static <T> long computeSize(ByteSequenceProvider<?> byteSequenceProvider) {
        return byteSequenceProvider.numSequences() * (long)Loader.sizeof(TF_TString.class);
    }

    public <T> void init(ByteSequenceProvider<T> byteSequenceProvider) {
        InitDataWriter writer = new InitDataWriter();
        byteSequenceProvider.forEach(writer::writeNext);
    }

    @Override
    public long size() {
        return this.data.capacity() - this.data.position();
    }

    @Override
    public byte[] getObject(long index) {
        Validator.getArgs(this, index);
        TF_TString tstring = this.data.getPointer(index);
        BytePointer ptr = tensorflow.TF_TString_GetDataPointer(tstring).capacity(tensorflow.TF_TString_GetSize(tstring));
        return ptr.getStringBytes();
    }

    @Override
    public DataBuffer<byte[]> setObject(byte[] values, long index) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public DataBuffer<byte[]> copyTo(DataBuffer<byte[]> dst, long size) {
        if (size == this.size() && dst instanceof ByteSequenceTensorBuffer) {
            ByteSequenceTensorBuffer tensorDst = (ByteSequenceTensorBuffer)dst;
            int i = 0;
            while ((long)i < size) {
                tensorflow.TF_TString_Assign(tensorDst.data.getPointer(i), this.data.getPointer(i));
                ++i;
            }
        } else {
            this.slowCopyTo(dst, size);
        }
        return this;
    }

    @Override
    public DataBuffer<byte[]> slice(long index, long size) {
        return new ByteSequenceTensorBuffer(this.data.getPointer(index), size);
    }

    ByteSequenceTensorBuffer(Pointer tensorMemory, long numElements) {
        this.data = (TF_TString)new TF_TString(tensorMemory).capacity(tensorMemory.position() + numElements);
    }

    static {
        try {
            Class.forName("org.tensorflow.TensorFlow");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class InitDataWriter {
        long index = 0L;

        private InitDataWriter() {
        }

        void writeNext(byte[] bytes) {
            try (PointerScope scope = new PointerScope();){
                TF_TString tstring = ByteSequenceTensorBuffer.this.data.getPointer(this.index++);
                tensorflow.TF_TString_Copy(tstring, new BytePointer(bytes), (long)bytes.length);
            }
        }
    }
}

