/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaLaunch", inputsClass=Inputs.class)
public final class XlaLaunch
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "XlaLaunch";
    private List<Output<?>> results;

    public XlaLaunch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int resultsLength = operation.outputListLength("results");
        this.results = Arrays.asList(operation.outputList(outputIdx, resultsLength));
        outputIdx += resultsLength;
    }

    public static XlaLaunch create(Scope scope, Iterable<Operand<?>> constants, Iterable<Operand<?>> args, Iterable<Operand<? extends TType>> resources, List<Class<? extends TType>> Tresults, ConcreteFunction function) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(constants));
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.addInputList(Operands.asOutputs(resources));
        opBuilder.setAttr("Tresults", Operands.toDataTypes(Tresults));
        opBuilder.setAttr("function", function);
        return new XlaLaunch(opBuilder.build());
    }

    public List<Output<?>> results() {
        return this.results;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.results.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaLaunch.class)
    public static class Inputs
    extends RawOpInputs<XlaLaunch> {
        public final Iterable<Operand<?>> constants;
        public final Iterable<Operand<?>> args;
        public final Iterable<Operand<? extends TType>> resources;
        public final DataType[] Tconstants;
        public final DataType[] Targs;
        public final DataType[] Tresults;

        public Inputs(GraphOperation op) {
            super(new XlaLaunch(op), op, Arrays.asList("Tconstants", "Targs", "Tresults"));
            int inputIndex = 0;
            int constantsLength = op.inputListLength("constants");
            this.constants = Arrays.asList((Operand[])op.inputList(inputIndex, constantsLength));
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex += constantsLength, argsLength));
            int resourcesLength = op.inputListLength("resources");
            this.resources = Arrays.asList((Operand[])op.inputList(inputIndex += argsLength, resourcesLength));
            inputIndex += resourcesLength;
            this.Tconstants = op.attributes().getAttrTypeList("Tconstants");
            this.Targs = op.attributes().getAttrTypeList("Targs");
            this.Tresults = op.attributes().getAttrTypeList("Tresults");
        }
    }
}

