/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaKeyValueSort", inputsClass=Inputs.class)
public final class KeyValueSort<T extends TNumber, U extends TType>
extends RawOp {
    public static final String OP_NAME = "XlaKeyValueSort";
    private Output<T> sortedKeys;
    private Output<U> sortedValues;

    public KeyValueSort(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sortedKeys = operation.output(outputIdx++);
        this.sortedValues = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TType> KeyValueSort<T, U> create(Scope scope, Operand<T> keys, Operand<U> values) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "KeyValueSort");
        opBuilder.addInput(keys.asOutput());
        opBuilder.addInput(values.asOutput());
        return new KeyValueSort<T, U>(opBuilder.build());
    }

    public Output<T> sortedKeys() {
        return this.sortedKeys;
    }

    public Output<U> sortedValues() {
        return this.sortedValues;
    }

    @OpInputsMetadata(outputsClass=KeyValueSort.class)
    public static class Inputs<T extends TNumber, U extends TType>
    extends RawOpInputs<KeyValueSort<T, U>> {
        public final Operand<T> keys;
        public final Operand<U> values;
        public final DataType K;
        public final DataType V;

        public Inputs(GraphOperation op) {
            super(new KeyValueSort(op), op, Arrays.asList("K", "V"));
            int inputIndex = 0;
            this.keys = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.K = op.attributes().getAttrType("K");
            this.V = op.attributes().getAttrType("V");
        }
    }
}

