/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUReplicatedOutput", inputsClass=Inputs.class)
public final class ReplicatedOutput<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "TPUReplicatedOutput";
    private List<Output<T>> outputs;

    public ReplicatedOutput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static <T extends TType> ReplicatedOutput<T> create(Scope scope, Operand<T> input, Long numReplicas) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ReplicatedOutput");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("num_replicas", numReplicas);
        return new ReplicatedOutput<T>(opBuilder.build());
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=ReplicatedOutput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ReplicatedOutput<T>> {
        public final Operand<T> input;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new ReplicatedOutput(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

