/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUPartitionedOutput", inputsClass=Inputs.class)
public final class PartitionedOutput<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "TPUPartitionedOutput";
    private List<Output<T>> output;

    public PartitionedOutput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static <T extends TType> PartitionedOutput<T> create(Scope scope, Operand<T> inputs, Long numSplits, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PartitionedOutput");
        opBuilder.addInput(inputs.asOutput());
        opBuilder.setAttr("num_splits", numSplits);
        if (options != null) {
            for (Options opts : options) {
                if (opts.partitionDim == null) continue;
                opBuilder.setAttr("partition_dim", opts.partitionDim);
            }
        }
        return new PartitionedOutput<T>(opBuilder.build());
    }

    public static Options partitionDim(Long partitionDim) {
        return new Options().partitionDim(partitionDim);
    }

    public List<Output<T>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=PartitionedOutput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<PartitionedOutput<T>> {
        public final Operand<T> inputs;
        public final DataType T;
        public final long partitionDim;

        public Inputs(GraphOperation op) {
            super(new PartitionedOutput(op), op, Arrays.asList("T", "partition_dim"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.partitionDim = op.attributes().getAttrInt("partition_dim");
        }
    }

    public static class Options {
        private Long partitionDim;

        private Options() {
        }

        public Options partitionDim(Long partitionDim) {
            this.partitionDim = partitionDim;
            return this;
        }
    }
}

