/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedCross", inputsClass=Inputs.class)
public final class RaggedCross<T extends TType, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "RaggedCross";
    private Output<T> outputValues;
    private Output<U> outputRowSplits;

    public RaggedCross(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputValues = operation.output(outputIdx++);
        this.outputRowSplits = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TNumber> RaggedCross<T, U> create(Scope scope, Iterable<Operand<?>> raggedValues, Iterable<Operand<?>> raggedRowSplits, Iterable<Operand<TInt64>> sparseIndices, Iterable<Operand<?>> sparseValues, Iterable<Operand<TInt64>> sparseShape, Iterable<Operand<?>> denseInputs, String inputOrder, Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outValuesType, Class<U> outRowSplitsType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(raggedValues));
        opBuilder.addInputList(Operands.asOutputs(raggedRowSplits));
        opBuilder.addInputList(Operands.asOutputs(sparseIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseValues));
        opBuilder.addInputList(Operands.asOutputs(sparseShape));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder.setAttr("input_order", inputOrder);
        opBuilder.setAttr("hashed_output", hashedOutput);
        opBuilder.setAttr("num_buckets", numBuckets);
        opBuilder.setAttr("hash_key", hashKey);
        opBuilder.setAttr("out_values_type", Operands.toDataType(outValuesType));
        opBuilder.setAttr("out_row_splits_type", Operands.toDataType(outRowSplitsType));
        return new RaggedCross<T, U>(opBuilder.build());
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<U> outputRowSplits() {
        return this.outputRowSplits;
    }

    @OpInputsMetadata(outputsClass=RaggedCross.class)
    public static class Inputs
    extends RawOpInputs<RaggedCross<?, ?>> {
        public final Iterable<Operand<?>> raggedValues;
        public final Iterable<Operand<?>> raggedRowSplits;
        public final Iterable<Operand<TInt64>> sparseIndices;
        public final Iterable<Operand<?>> sparseValues;
        public final Iterable<Operand<TInt64>> sparseShape;
        public final Iterable<Operand<?>> denseInputs;
        public final String inputOrder;
        public final boolean hashedOutput;
        public final long numBuckets;
        public final long hashKey;
        public final DataType[] raggedValuesTypes;
        public final DataType[] raggedSplitsTypes;
        public final DataType[] sparseValuesTypes;
        public final DataType[] denseTypes;
        public final DataType outValuesType;
        public final DataType outRowSplitsType;

        public Inputs(GraphOperation op) {
            super(new RaggedCross(op), op, Arrays.asList("input_order", "hashed_output", "num_buckets", "hash_key", "ragged_values_types", "ragged_splits_types", "sparse_values_types", "dense_types", "out_values_type", "out_row_splits_type"));
            int inputIndex = 0;
            int raggedValuesLength = op.inputListLength("ragged_values");
            this.raggedValues = Arrays.asList((Operand[])op.inputList(inputIndex, raggedValuesLength));
            int raggedRowSplitsLength = op.inputListLength("ragged_row_splits");
            this.raggedRowSplits = Arrays.asList((Operand[])op.inputList(inputIndex += raggedValuesLength, raggedRowSplitsLength));
            int sparseIndicesLength = op.inputListLength("sparse_indices");
            this.sparseIndices = Arrays.asList((Operand[])op.inputList(inputIndex += raggedRowSplitsLength, sparseIndicesLength));
            int sparseValuesLength = op.inputListLength("sparse_values");
            this.sparseValues = Arrays.asList((Operand[])op.inputList(inputIndex += sparseIndicesLength, sparseValuesLength));
            int sparseShapeLength = op.inputListLength("sparse_shape");
            this.sparseShape = Arrays.asList((Operand[])op.inputList(inputIndex += sparseValuesLength, sparseShapeLength));
            int denseInputsLength = op.inputListLength("dense_inputs");
            this.denseInputs = Arrays.asList((Operand[])op.inputList(inputIndex += sparseShapeLength, denseInputsLength));
            inputIndex += denseInputsLength;
            this.inputOrder = op.attributes().getAttrString("input_order");
            this.hashedOutput = op.attributes().getAttrBool("hashed_output");
            this.numBuckets = op.attributes().getAttrInt("num_buckets");
            this.hashKey = op.attributes().getAttrInt("hash_key");
            this.raggedValuesTypes = op.attributes().getAttrTypeList("ragged_values_types");
            this.raggedSplitsTypes = op.attributes().getAttrTypeList("ragged_splits_types");
            this.sparseValuesTypes = op.attributes().getAttrTypeList("sparse_values_types");
            this.denseTypes = op.attributes().getAttrTypeList("dense_types");
            this.outValuesType = op.attributes().getAttrType("out_values_type");
            this.outRowSplitsType = op.attributes().getAttrType("out_row_splits_type");
        }
    }
}

