/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="HashTableV2", inputsClass=Inputs.class)
public final class HashTable
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "HashTableV2";
    private Output<? extends TType> tableHandle;

    public HashTable(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tableHandle = operation.output(outputIdx++);
    }

    public static <T extends TType, U extends TType> HashTable create(Scope scope, Class<T> keyDtype, Class<U> valueDtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "HashTable");
        opBuilder.setAttr("key_dtype", Operands.toDataType(keyDtype));
        opBuilder.setAttr("value_dtype", Operands.toDataType(valueDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.useNodeNameSharing == null) continue;
                opBuilder.setAttr("use_node_name_sharing", opts.useNodeNameSharing);
            }
        }
        return new HashTable(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public Output<? extends TType> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.tableHandle;
    }

    @OpInputsMetadata(outputsClass=HashTable.class)
    public static class Inputs
    extends RawOpInputs<HashTable> {
        public final String container;
        public final String sharedName;
        public final boolean useNodeNameSharing;
        public final DataType keyDtype;
        public final DataType valueDtype;

        public Inputs(GraphOperation op) {
            super(new HashTable(op), op, Arrays.asList("container", "shared_name", "use_node_name_sharing", "key_dtype", "value_dtype"));
            boolean inputIndex = false;
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.useNodeNameSharing = op.attributes().getAttrBool("use_node_name_sharing");
            this.keyDtype = op.attributes().getAttrType("key_dtype");
            this.valueDtype = op.attributes().getAttrType("value_dtype");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }
    }
}

