/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="CTCLossV2", inputsClass=Inputs.class)
public final class CTCLossV2
extends RawOp {
    public static final String OP_NAME = "CTCLossV2";
    private Output<TFloat32> loss;
    private Output<TFloat32> gradient;

    public CTCLossV2(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.loss = operation.output(outputIdx++);
        this.gradient = operation.output(outputIdx++);
    }

    public static CTCLossV2 create(Scope scope, Operand<TFloat32> inputs, Operand<TInt64> labelsIndices, Operand<TInt32> labelsValues, Operand<TInt32> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(labelsIndices.asOutput());
        opBuilder.addInput(labelsValues.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.preprocessCollapseRepeated != null) {
                    opBuilder.setAttr("preprocess_collapse_repeated", opts.preprocessCollapseRepeated);
                }
                if (opts.ctcMergeRepeated != null) {
                    opBuilder.setAttr("ctc_merge_repeated", opts.ctcMergeRepeated);
                }
                if (opts.ignoreLongerOutputsThanInputs == null) continue;
                opBuilder.setAttr("ignore_longer_outputs_than_inputs", opts.ignoreLongerOutputsThanInputs);
            }
        }
        return new CTCLossV2(opBuilder.build());
    }

    public static Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
        return new Options().preprocessCollapseRepeated(preprocessCollapseRepeated);
    }

    public static Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
        return new Options().ctcMergeRepeated(ctcMergeRepeated);
    }

    public static Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
        return new Options().ignoreLongerOutputsThanInputs(ignoreLongerOutputsThanInputs);
    }

    public Output<TFloat32> loss() {
        return this.loss;
    }

    public Output<TFloat32> gradient() {
        return this.gradient;
    }

    @OpInputsMetadata(outputsClass=CTCLossV2.class)
    public static class Inputs
    extends RawOpInputs<CTCLossV2> {
        public final Operand<TFloat32> inputs;
        public final Operand<TInt64> labelsIndices;
        public final Operand<TInt32> labelsValues;
        public final Operand<TInt32> sequenceLength;
        public final boolean preprocessCollapseRepeated;
        public final boolean ctcMergeRepeated;
        public final boolean ignoreLongerOutputsThanInputs;

        public Inputs(GraphOperation op) {
            super(new CTCLossV2(op), op, Arrays.asList("preprocess_collapse_repeated", "ctc_merge_repeated", "ignore_longer_outputs_than_inputs"));
            int inputIndex = 0;
            this.inputs = op.input(inputIndex++);
            this.labelsIndices = op.input(inputIndex++);
            this.labelsValues = op.input(inputIndex++);
            this.sequenceLength = op.input(inputIndex++);
            this.preprocessCollapseRepeated = op.attributes().getAttrBool("preprocess_collapse_repeated");
            this.ctcMergeRepeated = op.attributes().getAttrBool("ctc_merge_repeated");
            this.ignoreLongerOutputsThanInputs = op.attributes().getAttrBool("ignore_longer_outputs_than_inputs");
        }
    }

    public static class Options {
        private Boolean preprocessCollapseRepeated;
        private Boolean ctcMergeRepeated;
        private Boolean ignoreLongerOutputsThanInputs;

        private Options() {
        }

        public Options preprocessCollapseRepeated(Boolean preprocessCollapseRepeated) {
            this.preprocessCollapseRepeated = preprocessCollapseRepeated;
            return this;
        }

        public Options ctcMergeRepeated(Boolean ctcMergeRepeated) {
            this.ctcMergeRepeated = ctcMergeRepeated;
            return this;
        }

        public Options ignoreLongerOutputsThanInputs(Boolean ignoreLongerOutputsThanInputs) {
            this.ignoreLongerOutputsThanInputs = ignoreLongerOutputsThanInputs;
            return this;
        }
    }
}

