/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MapDefun", inputsClass=Inputs.class)
public final class MapDefun
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "MapDefun";
    private List<Output<?>> output;

    public MapDefun(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static MapDefun create(Scope scope, Iterable<Operand<?>> arguments, Iterable<Operand<?>> capturedInputs, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, ConcreteFunction f, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(arguments));
        opBuilder.addInputList(Operands.asOutputs(capturedInputs));
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        opBuilder.setAttr("f", f);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxIntraOpParallelism == null) continue;
                opBuilder.setAttr("max_intra_op_parallelism", opts.maxIntraOpParallelism);
            }
        }
        return new MapDefun(opBuilder.build());
    }

    public static Options maxIntraOpParallelism(Long maxIntraOpParallelism) {
        return new Options().maxIntraOpParallelism(maxIntraOpParallelism);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=MapDefun.class)
    public static class Inputs
    extends RawOpInputs<MapDefun> {
        public final Iterable<Operand<?>> arguments;
        public final Iterable<Operand<?>> capturedInputs;
        public final DataType[] Targuments;
        public final DataType[] Tcaptured;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final long maxIntraOpParallelism;

        public Inputs(GraphOperation op) {
            super(new MapDefun(op), op, Arrays.asList("Targuments", "Tcaptured", "output_types", "output_shapes", "max_intra_op_parallelism"));
            int inputIndex = 0;
            int argumentsLength = op.inputListLength("arguments");
            this.arguments = Arrays.asList((Operand[])op.inputList(inputIndex, argumentsLength));
            int capturedInputsLength = op.inputListLength("captured_inputs");
            this.capturedInputs = Arrays.asList((Operand[])op.inputList(inputIndex += argumentsLength, capturedInputsLength));
            inputIndex += capturedInputsLength;
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.Tcaptured = op.attributes().getAttrTypeList("Tcaptured");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.maxIntraOpParallelism = op.attributes().getAttrInt("max_intra_op_parallelism");
        }
    }

    public static class Options {
        private Long maxIntraOpParallelism;

        private Options() {
        }

        public Options maxIntraOpParallelism(Long maxIntraOpParallelism) {
            this.maxIntraOpParallelism = maxIntraOpParallelism;
            return this;
        }
    }
}

