/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="RecordInput", inputsClass=Inputs.class)
public final class RecordInput
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "RecordInput";
    private Output<TString> records;

    public RecordInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.records = operation.output(outputIdx++);
    }

    public static RecordInput create(Scope scope, String filePattern, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("file_pattern", filePattern);
        if (options != null) {
            for (Options opts : options) {
                if (opts.fileRandomSeed != null) {
                    opBuilder.setAttr("file_random_seed", opts.fileRandomSeed);
                }
                if (opts.fileShuffleShiftRatio != null) {
                    opBuilder.setAttr("file_shuffle_shift_ratio", opts.fileShuffleShiftRatio.floatValue());
                }
                if (opts.fileBufferSize != null) {
                    opBuilder.setAttr("file_buffer_size", opts.fileBufferSize);
                }
                if (opts.fileParallelism != null) {
                    opBuilder.setAttr("file_parallelism", opts.fileParallelism);
                }
                if (opts.batchSize != null) {
                    opBuilder.setAttr("batch_size", opts.batchSize);
                }
                if (opts.compressionType == null) continue;
                opBuilder.setAttr("compression_type", opts.compressionType);
            }
        }
        return new RecordInput(opBuilder.build());
    }

    public static Options fileRandomSeed(Long fileRandomSeed) {
        return new Options().fileRandomSeed(fileRandomSeed);
    }

    public static Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
        return new Options().fileShuffleShiftRatio(fileShuffleShiftRatio);
    }

    public static Options fileBufferSize(Long fileBufferSize) {
        return new Options().fileBufferSize(fileBufferSize);
    }

    public static Options fileParallelism(Long fileParallelism) {
        return new Options().fileParallelism(fileParallelism);
    }

    public static Options batchSize(Long batchSize) {
        return new Options().batchSize(batchSize);
    }

    public static Options compressionType(String compressionType) {
        return new Options().compressionType(compressionType);
    }

    public Output<TString> records() {
        return this.records;
    }

    @Override
    public Output<TString> asOutput() {
        return this.records;
    }

    @OpInputsMetadata(outputsClass=RecordInput.class)
    public static class Inputs
    extends RawOpInputs<RecordInput> {
        public final String filePattern;
        public final long fileRandomSeed;
        public final float fileShuffleShiftRatio;
        public final long fileBufferSize;
        public final long fileParallelism;
        public final long batchSize;
        public final String compressionType;

        public Inputs(GraphOperation op) {
            super(new RecordInput(op), op, Arrays.asList("file_pattern", "file_random_seed", "file_shuffle_shift_ratio", "file_buffer_size", "file_parallelism", "batch_size", "compression_type"));
            boolean inputIndex = false;
            this.filePattern = op.attributes().getAttrString("file_pattern");
            this.fileRandomSeed = op.attributes().getAttrInt("file_random_seed");
            this.fileShuffleShiftRatio = op.attributes().getAttrFloat("file_shuffle_shift_ratio");
            this.fileBufferSize = op.attributes().getAttrInt("file_buffer_size");
            this.fileParallelism = op.attributes().getAttrInt("file_parallelism");
            this.batchSize = op.attributes().getAttrInt("batch_size");
            this.compressionType = op.attributes().getAttrString("compression_type");
        }
    }

    public static class Options {
        private Long fileRandomSeed;
        private Float fileShuffleShiftRatio;
        private Long fileBufferSize;
        private Long fileParallelism;
        private Long batchSize;
        private String compressionType;

        private Options() {
        }

        public Options fileRandomSeed(Long fileRandomSeed) {
            this.fileRandomSeed = fileRandomSeed;
            return this;
        }

        public Options fileShuffleShiftRatio(Float fileShuffleShiftRatio) {
            this.fileShuffleShiftRatio = fileShuffleShiftRatio;
            return this;
        }

        public Options fileBufferSize(Long fileBufferSize) {
            this.fileBufferSize = fileBufferSize;
            return this;
        }

        public Options fileParallelism(Long fileParallelism) {
            this.fileParallelism = fileParallelism;
            return this;
        }

        public Options batchSize(Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Options compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }
    }
}

