/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="TopKV2", inputsClass=Inputs.class)
public final class TopK<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "TopKV2";
    private Output<T> values;
    private Output<TInt32> indices;

    public TopK(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
        this.indices = operation.output(outputIdx++);
    }

    public static <T extends TNumber> TopK<T> create(Scope scope, Operand<T> input, Operand<TInt32> k, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TopK");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(k.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.sorted == null) continue;
                opBuilder.setAttr("sorted", opts.sorted);
            }
        }
        return new TopK<T>(opBuilder.build());
    }

    public static Options sorted(Boolean sorted) {
        return new Options().sorted(sorted);
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt32> indices() {
        return this.indices;
    }

    @OpInputsMetadata(outputsClass=TopK.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<TopK<T>> {
        public final Operand<T> input;
        public final Operand<TInt32> k;
        public final boolean sorted;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new TopK(op), op, Arrays.asList("sorted", "T"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.k = op.input(inputIndex++);
            this.sorted = op.attributes().getAttrBool("sorted");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean sorted;

        private Options() {
        }

        public Options sorted(Boolean sorted) {
            this.sorted = sorted;
            return this;
        }
    }
}

