/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedConv2D", inputsClass=Inputs.class)
public final class QuantizedConv2d<V extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedConv2D";
    private Output<V> output;
    private Output<TFloat32> minOutput;
    private Output<TFloat32> maxOutput;

    public QuantizedConv2d(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOutput = operation.output(outputIdx++);
        this.maxOutput = operation.output(outputIdx++);
    }

    public static <V extends TNumber> QuantizedConv2d<V> create(Scope scope, Operand<? extends TNumber> input, Operand<? extends TNumber> filter, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minFilter, Operand<TFloat32> maxFilter, Class<V> outType, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "QuantizedConv2d");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minFilter.asOutput());
        opBuilder.addInput(maxFilter.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new QuantizedConv2d<V>(opBuilder.build());
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options dilations(Long ... dilations) {
        return new Options().dilations(dilations);
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<TFloat32> minOutput() {
        return this.minOutput;
    }

    public Output<TFloat32> maxOutput() {
        return this.maxOutput;
    }

    @OpInputsMetadata(outputsClass=QuantizedConv2d.class)
    public static class Inputs
    extends RawOpInputs<QuantizedConv2d<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<? extends TNumber> filter;
        public final Operand<TFloat32> minInput;
        public final Operand<TFloat32> maxInput;
        public final Operand<TFloat32> minFilter;
        public final Operand<TFloat32> maxFilter;
        public final DataType Tinput;
        public final DataType Tfilter;
        public final DataType outType;
        public final long[] strides;
        public final String padding;
        public final long[] dilations;

        public Inputs(GraphOperation op) {
            super(new QuantizedConv2d(op), op, Arrays.asList("Tinput", "Tfilter", "out_type", "strides", "padding", "dilations"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.minInput = op.input(inputIndex++);
            this.maxInput = op.input(inputIndex++);
            this.minFilter = op.input(inputIndex++);
            this.maxFilter = op.input(inputIndex++);
            this.Tinput = op.attributes().getAttrType("Tinput");
            this.Tfilter = op.attributes().getAttrType("Tfilter");
            this.outType = op.attributes().getAttrType("out_type");
            this.strides = op.attributes().getAttrIntList("strides");
            this.padding = op.attributes().getAttrString("padding");
            this.dilations = op.attributes().getAttrIntList("dilations");
        }
    }

    public static class Options {
        private List<Long> dilations;

        private Options() {
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options dilations(Long ... dilations) {
            this.dilations = Arrays.asList(dilations);
            return this;
        }
    }
}

