/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.dense.DoubleDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.DoubleSparseNdArray;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt64;

public final class TFloat64Mapper
extends TensorMapper<TFloat64> {
    @Override
    protected TFloat64 mapDense(RawTensor tensor) {
        DoubleDataBuffer buffer = TensorBuffers.toDoubles(TFloat64Mapper.nativeHandle(tensor));
        return new DenseTFloat64(tensor, buffer);
    }

    @Override
    protected SparseTensor<TFloat64> mapSparse(TInt64 indices, TFloat64 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTFloat64(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTFloat64
    extends DoubleSparseNdArray
    implements TFloat64,
    SparseTensor<TFloat64> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TFloat64> type() {
            return TFloat64.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TFloat64 values() {
            return (TFloat64)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTFloat64(TInt64 indices, TFloat64 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, 0.0, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTFloat64
    extends DoubleDenseNdArray
    implements TFloat64 {
        final RawTensor rawTensor;

        public Class<TFloat64> type() {
            return TFloat64.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat64(RawTensor rawTensor, DoubleDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

