/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TPUReplicatedInput", inputsClass=Inputs.class)
@Deprecated
public final class TPUReplicatedInput<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TPUReplicatedInput";
    private Output<T> output;

    public TPUReplicatedInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> TPUReplicatedInput<T> create(Scope scope, Iterable<Operand<T>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        if (options != null) {
            for (Options opts : options) {
                if (opts.isMirroredVariable != null) {
                    opBuilder.setAttr("is_mirrored_variable", opts.isMirroredVariable);
                }
                if (opts.index != null) {
                    opBuilder.setAttr("index", opts.index);
                }
                if (opts.isPacked == null) continue;
                opBuilder.setAttr("is_packed", opts.isPacked);
            }
        }
        return new TPUReplicatedInput<T>(opBuilder.build());
    }

    public static Options isMirroredVariable(Boolean isMirroredVariable) {
        return new Options().isMirroredVariable(isMirroredVariable);
    }

    public static Options index(Long index) {
        return new Options().index(index);
    }

    public static Options isPacked(Boolean isPacked) {
        return new Options().isPacked(isPacked);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=TPUReplicatedInput.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<TPUReplicatedInput<T>> {
        public final Iterable<Operand<T>> inputs;
        public final DataType T;
        public final boolean isMirroredVariable;
        public final long index;
        public final boolean isPacked;

        public Inputs(GraphOperation op) {
            super(new TPUReplicatedInput(op), op, Arrays.asList("T", "is_mirrored_variable", "index", "is_packed"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.T = op.attributes().getAttrType("T");
            this.isMirroredVariable = op.attributes().getAttrBool("is_mirrored_variable");
            this.index = op.attributes().getAttrInt("index");
            this.isPacked = op.attributes().getAttrBool("is_packed");
        }
    }

    public static class Options {
        private Boolean isMirroredVariable;
        private Long index;
        private Boolean isPacked;

        private Options() {
        }

        public Options isMirroredVariable(Boolean isMirroredVariable) {
            this.isMirroredVariable = isMirroredVariable;
            return this;
        }

        public Options index(Long index) {
            this.index = index;
            return this;
        }

        public Options isPacked(Boolean isPacked) {
            this.isPacked = isPacked;
            return this;
        }
    }
}

